<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTagScholarship is autogenerate by UniModel generator
 *
 * This is the model class for table "tag_scholarship".
 *
 * The followings are the available columns in table 'tag_scholarship':
 * @property integer $tag_scholarship_id
 * @property integer $tag_ref_id
 * @property string $scholarship_ref_id
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property Tag $tagRef
 * @property Scholarship $scholarshipRef
 * @property LoginMaster $addedBy
 */
class BaseTagScholarship extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TagScholarship the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tag_scholarship';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('tag_ref_id, scholarship_ref_id, added_by, added_on', 'required'),
			array('tag_ref_id', 'numerical', 'integerOnly'=>true),
			array('scholarship_ref_id, added_by', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tag_scholarship_id, tag_ref_id, scholarship_ref_id, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'tagRef' => array(self::BELONGS_TO, 'Tag', 'tag_ref_id'),
			'scholarshipRef' => array(self::BELONGS_TO, 'Scholarship', 'scholarship_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tag_scholarship_id' => 'Tag Scholarship',
			'tag_ref_id' => 'Tag Ref',
			'scholarship_ref_id' => 'Scholarship Ref',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tag_scholarship_id',$this->tag_scholarship_id);
		$criteria->compare('tag_ref_id',$this->tag_ref_id);
		$criteria->compare('scholarship_ref_id',$this->scholarship_ref_id,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}