<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTaskLog is autogenerate by UniModel generator
 *
 * This is the model class for table "task_log".
 *
 * The followings are the available columns in table 'task_log':
 * @property string $task_log_id
 * @property string $task_ref_id
 * @property integer $assigned_to
 * @property integer $reassigned_to
 * @property integer $status_ref_id
 * @property string $start_date
 * @property string $end_date
 * @property string $added_on
 * @property string $comments
 *
 * The followings are the available model relations:
 * @property TblAdmin $assignedTo
 * @property TblAdmin $reassignedTo
 * @property LookupTaskStatus $statusRef
 * @property Task $taskRef
 */
class BaseTaskLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TaskLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'task_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('task_ref_id, status_ref_id', 'required'),
			array('assigned_to, reassigned_to, status_ref_id', 'numerical', 'integerOnly'=>true),
			array('task_ref_id', 'length', 'max'=>10),
			array('start_date, end_date, added_on, comments', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('task_log_id, task_ref_id, assigned_to, reassigned_to, status_ref_id, start_date, end_date, added_on, comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'assignedTo' => array(self::BELONGS_TO, 'TblAdmin', 'assigned_to'),
			'reassignedTo' => array(self::BELONGS_TO, 'TblAdmin', 'reassigned_to'),
			'statusRef' => array(self::BELONGS_TO, 'LookupTaskStatus', 'status_ref_id'),
			'taskRef' => array(self::BELONGS_TO, 'Task', 'task_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'task_log_id' => 'Task Log',
			'task_ref_id' => 'Task Ref',
			'assigned_to' => 'Assigned To',
			'reassigned_to' => 'Reassigned To',
			'status_ref_id' => 'Status Ref',
			'start_date' => 'Start Date',
			'end_date' => 'End Date',
			'added_on' => 'Added On',
			'comments' => 'Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('task_log_id',$this->task_log_id,true);
		$criteria->compare('task_ref_id',$this->task_ref_id,true);
		$criteria->compare('assigned_to',$this->assigned_to);
		$criteria->compare('reassigned_to',$this->reassigned_to);
		$criteria->compare('status_ref_id',$this->status_ref_id);
		$criteria->compare('start_date',$this->start_date,true);
		$criteria->compare('end_date',$this->end_date,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('comments',$this->comments,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}