<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblEventsCountries is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_events_countries".
 *
 * The followings are the available columns in table 'tbl_events_countries':
 * @property integer $tbl_events_countries_id
 * @property integer $event_ref_id
 * @property integer $country_ref_id
 * @property string $is_active
 *
 * The followings are the available model relations:
 * @property TblCountryMaster $countryRef
 * @property TblEvent $eventRef
 */
class BaseTblEventsCountries extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblEventsCountries the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_events_countries';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id, country_ref_id', 'numerical', 'integerOnly'=>true),
			array('is_active', 'length', 'max'=>1),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_events_countries_id, event_ref_id, country_ref_id, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'eventRef' => array(self::BELONGS_TO, 'TblEvent', 'event_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_events_countries_id' => 'Tbl Events Countries',
			'event_ref_id' => 'Event Ref',
			'country_ref_id' => 'Country Ref',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_events_countries_id',$this->tbl_events_countries_id);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('is_active',$this->is_active,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}