<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblMockTest is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_mock_test".
 *
 * The followings are the available columns in table 'tbl_mock_test':
 * @property string $mock_test_id
 * @property string $test_name
 * @property string $test_slug_name
 * @property string $description
 * @property string $instructions
 * @property string $test_message
 * @property string $applicable_to
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 * @property string $is_visible
 * @property string $test_type
 *
 * The followings are the available model relations:
 * @property LookupMocktestCriteria[] $lookupMocktestCriterias
 * @property MockTestCountries[] $mockTestCountries
 * @property MockTestDepartment[] $mockTestDepartments
 * @property MockTestEntranceExam[] $mockTestEntranceExams
 * @property MockTestResult[] $mockTestResults
 * @property MockTestSections[] $mockTestSections
 * @property MockTestSubjects[] $mockTestSubjects
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseTblMockTest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblMockTest the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_mock_test';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('test_name, test_slug_name', 'length', 'max'=>100),
			array('description', 'length', 'max'=>255),
			array('applicable_to', 'length', 'max'=>7),
			array('is_active, is_visible', 'length', 'max'=>1),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('test_type', 'length', 'max'=>12),
			array('instructions, test_message, added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('mock_test_id, test_name, test_slug_name, description, instructions, test_message, applicable_to, is_active, added_on, added_by, modified_on, modified_by, is_visible, test_type', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'lookupMocktestCriterias' => array(self::HAS_MANY, 'LookupMocktestCriteria', 'mock_test_ref_id'),
			'mockTestCountries' => array(self::HAS_MANY, 'MockTestCountries', 'mock_test_ref_id'),
			'mockTestDepartments' => array(self::HAS_MANY, 'MockTestDepartment', 'mock_test_ref_id'),
			'mockTestEntranceExams' => array(self::HAS_MANY, 'MockTestEntranceExam', 'mock_test_ref_id'),
			'mockTestResults' => array(self::HAS_MANY, 'MockTestResult', 'mock_test_ref_id'),
			'mockTestSections' => array(self::HAS_MANY, 'MockTestSections', 'mock_test_ref_id'),
			'mockTestSubjects' => array(self::HAS_MANY, 'MockTestSubjects', 'mock_test_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'mock_test_id' => 'Mock Test',
			'test_name' => 'Test Name',
			'test_slug_name' => 'Test Slug Name',
			'description' => 'Description',
			'instructions' => 'Instructions',
			'test_message' => 'Test Message',
			'applicable_to' => 'Applicable To',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'is_visible' => 'Is Visible',
			'test_type' => 'Test Type',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('mock_test_id',$this->mock_test_id,true);
		$criteria->compare('test_name',$this->test_name,true);
		$criteria->compare('test_slug_name',$this->test_slug_name,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('instructions',$this->instructions,true);
		$criteria->compare('test_message',$this->test_message,true);
		$criteria->compare('applicable_to',$this->applicable_to,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('is_visible',$this->is_visible,true);
		$criteria->compare('test_type',$this->test_type,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}