<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblSiAgreement is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_si_agreement".
 *
 * The followings are the available columns in table 'tbl_si_agreement':
 * @property string $agreement_id
 * @property integer $inst_ref_id
 * @property string $agreement_conditions
 * @property string $commercial_conditions
 * @property string $name_of_approver
 * @property string $designation
 * @property string $is_agree
 * @property string $agree_added_on
 * @property string $is_mobile_verify
 * @property string $added_on
 * @property string $added_by
 * @property string $is_mail_sent
 * @property string $mail_sent_on
 * @property string $mail_open_date
 * @property string $link_open_date
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TblSiDi $instRef
 */
class BaseTblSiAgreement extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblSiAgreement the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_si_agreement';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('inst_ref_id, commercial_conditions, added_on', 'required'),
			array('inst_ref_id', 'numerical', 'integerOnly'=>true),
			array('commercial_conditions', 'length', 'max'=>500),
			array('name_of_approver', 'length', 'max'=>100),
			array('designation', 'length', 'max'=>50),
			array('is_agree, is_mobile_verify, is_mail_sent', 'length', 'max'=>1),
			array('added_by', 'length', 'max'=>10),
			array('agreement_conditions, agree_added_on, mail_sent_on, mail_open_date, link_open_date', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('agreement_id, inst_ref_id, agreement_conditions, commercial_conditions, name_of_approver, designation, is_agree, agree_added_on, is_mobile_verify, added_on, added_by, is_mail_sent, mail_sent_on, mail_open_date, link_open_date', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'instRef' => array(self::BELONGS_TO, 'TblSiDi', 'inst_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'agreement_id' => 'Agreement',
			'inst_ref_id' => 'Inst Ref',
			'agreement_conditions' => 'Agreement Conditions',
			'commercial_conditions' => 'Commercial Conditions',
			'name_of_approver' => 'Name Of Approver',
			'designation' => 'Designation',
			'is_agree' => 'Is Agree',
			'agree_added_on' => 'Agree Added On',
			'is_mobile_verify' => 'Is Mobile Verify',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'is_mail_sent' => 'Is Mail Sent',
			'mail_sent_on' => 'Mail Sent On',
			'mail_open_date' => 'Mail Open Date',
			'link_open_date' => 'Link Open Date',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('agreement_id',$this->agreement_id,true);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('agreement_conditions',$this->agreement_conditions,true);
		$criteria->compare('commercial_conditions',$this->commercial_conditions,true);
		$criteria->compare('name_of_approver',$this->name_of_approver,true);
		$criteria->compare('designation',$this->designation,true);
		$criteria->compare('is_agree',$this->is_agree,true);
		$criteria->compare('agree_added_on',$this->agree_added_on,true);
		$criteria->compare('is_mobile_verify',$this->is_mobile_verify,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('is_mail_sent',$this->is_mail_sent,true);
		$criteria->compare('mail_sent_on',$this->mail_sent_on,true);
		$criteria->compare('mail_open_date',$this->mail_open_date,true);
		$criteria->compare('link_open_date',$this->link_open_date,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}