<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblUniCourses is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_uni_courses".
 *
 * The followings are the available columns in table 'tbl_uni_courses':
 * @property string $course_id
 * @property string $course_code
 * @property integer $uni_ref_id
 * @property integer $college_ref_id
 * @property integer $department_ref_id
 * @property integer $department_old_id
 * @property integer $subject_ref_id
 * @property integer $course_subject_ref_id
 * @property string $course_name
 * @property string $course_slug_name
 * @property string $course_desc
 * @property string $course_level
 * @property integer $degree_granted_ref_id
 * @property integer $popular_degree_ref_id
 * @property string $course_duration
 * @property string $course_duration_old
 * @property string $duration_commentary
 * @property string $course_mode
 * @property string $admission_page_link
 * @property string $course_start_date
 * @property string $course_start_date1
 * @property string $course_start_date2
 * @property integer $course_fees
 * @property string $course_fees_commentary
 * @property integer $higher_end_fees
 * @property string $course_page_link
 * @property string $course_ranking
 * @property integer $total_students
 * @property integer $male_students_percent
 * @property integer $female_students_percent
 * @property integer $full_time_per
 * @property integer $part_time_per
 * @property integer $total_applicants
 * @property integer $total_seats_available
 * @property string $international_stud_per
 * @property string $home_region_stud_per
 * @property integer $stud_going_high_edu
 * @property integer $stud_going_high_internat_edu
 * @property string $higher_studies_comment
 * @property string $placement_per
 * @property string $test_needed
 * @property string $cut_off_marks
 * @property string $top_faculty
 * @property string $summer_intership
 * @property integer $applicant_to_offer_ratio
 * @property integer $applicant_to_enrolment_ratio
 * @property string $uni_acceptance_rate
 * @property integer $vintage
 * @property string $application_start_date
 * @property string $application_last_date
 * @property string $application_sale_last_date
 * @property string $professors_review
 * @property string $stud_reviews_of_professor
 * @property string $admission_difficulty
 * @property string $student_rating
 * @property string $is_twining
 * @property string $twining_comment
 * @property string $admission_quota
 * @property string $degree_granted
 * @property string $dept_associated
 * @property string $uni_insights
 * @property string $teaching_pattern
 * @property string $syllabus
 * @property string $number_of_intakes
 * @property string $application_process
 * @property string $application_form_url
 * @property string $is_scholarship
 * @property string $scholarship_availability
 * @property string $scholarship_commentary
 * @property string $eligibility_commentary
 * @property string $hostel_availabilty
 * @property string $placement_commentary
 * @property string $placement_specialisation
 * @property integer $placement_percent
 * @property string $low_sal_range
 * @property integer $low_sal_range_currency_ref_id
 * @property string $high_sal_range
 * @property integer $high_sal_range_currency_ref_id
 * @property string $avg_salary
 * @property integer $avg_salary_currency_ref_id
 * @property string $median_salary
 * @property integer $median_salary_currency_ref_id
 * @property string $high_domestic_salary
 * @property integer $high_domestic_salary_currency_ref_id
 * @property string $high_international_salary
 * @property integer $high_international_salary_currency_ref_id
 * @property integer $critical_high_percent
 * @property integer $critical_medium_percent
 * @property integer $critical_low_percent
 * @property string $is_active
 * @property string $added_on
 * @property string $modified_on
 * @property string $additional_comments
 *
 * The followings are the available model relations:
 * @property CourseAffiliation[] $courseAffiliations
 * @property CourseApplicationDates[] $courseApplicationDates
 * @property CourseEligibility[] $courseEligibilities
 * @property CourseFees[] $courseFees
 * @property CoursePlacementCompany[] $coursePlacementCompanies
 * @property CoursePlacementTopCompany[] $coursePlacementTopCompanies
 * @property CoursePlacementType[] $coursePlacementTypes
 * @property CourseStartDate[] $courseStartDates
 * @property CourseTwining[] $courseTwinings
 * @property MdmCourseDump[] $mdmCourseDumps
 * @property MdmCourseLog[] $mdmCourseLogs
 * @property LookupDepartment $departmentRef
 * @property LookupCurrency $avgSalaryCurrencyRef
 * @property TblUniCollege $collegeRef
 * @property LookupDegreeGranted $degreeGrantedRef
 * @property LookupCurrency $highDomesticSalaryCurrencyRef
 * @property LookupCurrency $highInternationalSalaryCurrencyRef
 * @property LookupCurrency $highSalRangeCurrencyRef
 * @property LookupCurrency $lowSalRangeCurrencyRef
 * @property LookupCurrency $medianSalaryCurrencyRef
 * @property LookupPopularDegree $popularDegreeRef
 * @property TblUniversityMaster $uniRef
 */
class BaseTblUniCourses extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblUniCourses the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_uni_courses';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'required'),
			array('uni_ref_id, college_ref_id, department_ref_id, department_old_id, subject_ref_id, course_subject_ref_id, degree_granted_ref_id, popular_degree_ref_id, course_fees, higher_end_fees, total_students, male_students_percent, female_students_percent, full_time_per, part_time_per, total_applicants, total_seats_available, stud_going_high_edu, stud_going_high_internat_edu, applicant_to_offer_ratio, applicant_to_enrolment_ratio, vintage, placement_percent, low_sal_range_currency_ref_id, high_sal_range_currency_ref_id, avg_salary_currency_ref_id, median_salary_currency_ref_id, high_domestic_salary_currency_ref_id, high_international_salary_currency_ref_id, critical_high_percent, critical_medium_percent, critical_low_percent', 'numerical', 'integerOnly'=>true),
			array('course_code', 'length', 'max'=>50),
			array('course_name, course_slug_name, course_level, course_start_date, higher_studies_comment, application_sale_last_date, professors_review, stud_reviews_of_professor, student_rating, admission_quota, degree_granted', 'length', 'max'=>255),
			array('course_duration, course_duration_old, course_start_date1, course_start_date2, course_ranking, international_stud_per, home_region_stud_per, placement_per, cut_off_marks, uni_acceptance_rate, application_start_date, application_last_date, low_sal_range, high_sal_range, avg_salary, median_salary, high_domestic_salary, high_international_salary', 'length', 'max'=>10),
			array('course_mode', 'length', 'max'=>18),
			array('summer_intership', 'length', 'max'=>500),
			array('is_twining, is_scholarship, is_active', 'length', 'max'=>1),
			array('dept_associated', 'length', 'max'=>100),
			array('teaching_pattern', 'length', 'max'=>12),
			array('number_of_intakes, hostel_availabilty', 'length', 'max'=>7),
			array('scholarship_availability', 'length', 'max'=>6),
			array('course_desc, duration_commentary, admission_page_link, course_fees_commentary, course_page_link, test_needed, top_faculty, admission_difficulty, twining_comment, uni_insights, syllabus, application_process, application_form_url, scholarship_commentary, eligibility_commentary, placement_commentary, placement_specialisation, added_on, modified_on, additional_comments', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_id, course_code, uni_ref_id, college_ref_id, department_ref_id, department_old_id, subject_ref_id, course_subject_ref_id, course_name, course_slug_name, course_desc, course_level, degree_granted_ref_id, popular_degree_ref_id, course_duration, course_duration_old, duration_commentary, course_mode, admission_page_link, course_start_date, course_start_date1, course_start_date2, course_fees, course_fees_commentary, higher_end_fees, course_page_link, course_ranking, total_students, male_students_percent, female_students_percent, full_time_per, part_time_per, total_applicants, total_seats_available, international_stud_per, home_region_stud_per, stud_going_high_edu, stud_going_high_internat_edu, higher_studies_comment, placement_per, test_needed, cut_off_marks, top_faculty, summer_intership, applicant_to_offer_ratio, applicant_to_enrolment_ratio, uni_acceptance_rate, vintage, application_start_date, application_last_date, application_sale_last_date, professors_review, stud_reviews_of_professor, admission_difficulty, student_rating, is_twining, twining_comment, admission_quota, degree_granted, dept_associated, uni_insights, teaching_pattern, syllabus, number_of_intakes, application_process, application_form_url, is_scholarship, scholarship_availability, scholarship_commentary, eligibility_commentary, hostel_availabilty, placement_commentary, placement_specialisation, placement_percent, low_sal_range, low_sal_range_currency_ref_id, high_sal_range, high_sal_range_currency_ref_id, avg_salary, avg_salary_currency_ref_id, median_salary, median_salary_currency_ref_id, high_domestic_salary, high_domestic_salary_currency_ref_id, high_international_salary, high_international_salary_currency_ref_id, critical_high_percent, critical_medium_percent, critical_low_percent, is_active, added_on, modified_on, additional_comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'courseAffiliations' => array(self::HAS_MANY, 'CourseAffiliation', 'uni_course_ref_id'),
			'courseApplicationDates' => array(self::HAS_MANY, 'CourseApplicationDates', 'uni_course_ref_id'),
			'courseEligibilities' => array(self::HAS_MANY, 'CourseEligibility', 'uni_course_ref_id'),
			'courseFees' => array(self::HAS_MANY, 'CourseFees', 'uni_course_ref_id'),
			'coursePlacementCompanies' => array(self::HAS_MANY, 'CoursePlacementCompany', 'uni_course_ref_id'),
			'coursePlacementTopCompanies' => array(self::HAS_MANY, 'CoursePlacementTopCompany', 'uni_course_ref_id'),
			'coursePlacementTypes' => array(self::HAS_MANY, 'CoursePlacementType', 'uni_course_ref_id'),
			'courseStartDates' => array(self::HAS_MANY, 'CourseStartDate', 'uni_course_ref_id'),
			'courseTwinings' => array(self::HAS_MANY, 'CourseTwining', 'uni_course_ref_id'),
			'mdmCourseDumps' => array(self::HAS_MANY, 'MdmCourseDump', 'course_ref_id'),
			'mdmCourseLogs' => array(self::HAS_MANY, 'MdmCourseLog', 'course_ref_id'),
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'avgSalaryCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'avg_salary_currency_ref_id'),
			'collegeRef' => array(self::BELONGS_TO, 'TblUniCollege', 'college_ref_id'),
			'degreeGrantedRef' => array(self::BELONGS_TO, 'LookupDegreeGranted', 'degree_granted_ref_id'),
			'highDomesticSalaryCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'high_domestic_salary_currency_ref_id'),
			'highInternationalSalaryCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'high_international_salary_currency_ref_id'),
			'highSalRangeCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'high_sal_range_currency_ref_id'),
			'lowSalRangeCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'low_sal_range_currency_ref_id'),
			'medianSalaryCurrencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'median_salary_currency_ref_id'),
			'popularDegreeRef' => array(self::BELONGS_TO, 'LookupPopularDegree', 'popular_degree_ref_id'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'cf' => array(self::HAS_ONE, 'CourseFees', 'uni_course_ref_id',),
			'contact' => array(self::HAS_ONE, 'UniCourseContact', 'uni_course_ref_id',),
			'contacts' => array(self::HAS_MANY, 'UniCourseContact', 'uni_course_ref_id',),
			'testRef' => array(self::HAS_ONE, 'UniCourseTest', 'uni_course_ref_id',),
			'testRefs' => array(self::HAS_MANY, 'UniCourseTest', 'uni_course_ref_id',),
			'CourseReservationRef' => array(self::HAS_MANY, 'UniCourseReservation', 'uni_course_ref_id',),
                        'CoursePlacementsRef' => array(self::HAS_MANY, 'UniCoursePlacement', 'uni_course_ref_id','condition'=>'uni_course_ref_id IS NOT NULL'),
			'hostel' => array(self::HAS_ONE, 'HostelInfo', 'uni_course_ref_id',),
			'hostels' => array(self::HAS_MANY, 'HostelInfo', 'uni_course_ref_id',),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_id' => 'Course',
			'course_code' => 'Course Code',
			'uni_ref_id' => 'Uni Ref',
			'college_ref_id' => 'College Ref',
			'department_ref_id' => 'Department Ref',
			'department_old_id' => 'Department Old',
			'subject_ref_id' => 'Subject Ref',
			'course_subject_ref_id' => 'Course Subject Ref',
			'course_name' => 'Course Name',
			'course_slug_name' => 'Course Slug Name',
			'course_desc' => 'Course Desc',
			'course_level' => 'Course Level',
			'degree_granted_ref_id' => 'Degree Granted Ref',
			'popular_degree_ref_id' => 'Popular Degree Ref',
			'course_duration' => 'Course Duration',
			'course_duration_old' => 'Course Duration Old',
			'duration_commentary' => 'Duration Commentary',
			'course_mode' => 'Course Mode',
			'admission_page_link' => 'Admission Page Link',
			'course_start_date' => 'Course Start Date',
			'course_start_date1' => 'Course Start Date1',
			'course_start_date2' => 'Course Start Date2',
			'course_fees' => 'Course Fees',
			'course_fees_commentary' => 'Course Fees Commentary',
			'higher_end_fees' => 'Higher End Fees',
			'course_page_link' => 'Course Page Link',
			'course_ranking' => 'Course Ranking',
			'total_students' => 'Total Students',
			'male_students_percent' => 'Male Students Percent',
			'female_students_percent' => 'Female Students Percent',
			'full_time_per' => 'Full Time Per',
			'part_time_per' => 'Part Time Per',
			'total_applicants' => 'Total Applicants',
			'total_seats_available' => 'Total Seats Available',
			'international_stud_per' => 'International Stud Per',
			'home_region_stud_per' => 'Home Region Stud Per',
			'stud_going_high_edu' => 'Stud Going High Edu',
			'stud_going_high_internat_edu' => 'Stud Going High Internat Edu',
			'higher_studies_comment' => 'Higher Studies Comment',
			'placement_per' => 'Placement Per',
			'test_needed' => 'Test Needed',
			'cut_off_marks' => 'Cut Off Marks',
			'top_faculty' => 'Top Faculty',
			'summer_intership' => 'Summer Intership',
			'applicant_to_offer_ratio' => 'Applicant To Offer Ratio',
			'applicant_to_enrolment_ratio' => 'Applicant To Enrolment Ratio',
			'uni_acceptance_rate' => 'Uni Acceptance Rate',
			'vintage' => 'Vintage',
			'application_start_date' => 'Application Start Date',
			'application_last_date' => 'Application Last Date',
			'application_sale_last_date' => 'Application Sale Last Date',
			'professors_review' => 'Professors Review',
			'stud_reviews_of_professor' => 'Stud Reviews Of Professor',
			'admission_difficulty' => 'Admission Difficulty',
			'student_rating' => 'Student Rating',
			'is_twining' => 'Is Twining',
			'twining_comment' => 'Twining Comment',
			'admission_quota' => 'Admission Quota',
			'degree_granted' => 'Degree Granted',
			'dept_associated' => 'Dept Associated',
			'uni_insights' => 'Uni Insights',
			'teaching_pattern' => 'Teaching Pattern',
			'syllabus' => 'Syllabus',
			'number_of_intakes' => 'Number Of Intakes',
			'application_process' => 'Application Process',
			'application_form_url' => 'Application Form Url',
			'is_scholarship' => 'Is Scholarship',
			'scholarship_availability' => 'Scholarship Availability',
			'scholarship_commentary' => 'Scholarship Commentary',
			'eligibility_commentary' => 'Eligibility Commentary',
			'hostel_availabilty' => 'Hostel Availabilty',
			'placement_commentary' => 'Placement Commentary',
			'placement_specialisation' => 'Placement Specialisation',
			'placement_percent' => 'Placement Percent',
			'low_sal_range' => 'Low Sal Range',
			'low_sal_range_currency_ref_id' => 'Low Sal Range Currency Ref',
			'high_sal_range' => 'High Sal Range',
			'high_sal_range_currency_ref_id' => 'High Sal Range Currency Ref',
			'avg_salary' => 'Avg Salary',
			'avg_salary_currency_ref_id' => 'Avg Salary Currency Ref',
			'median_salary' => 'Median Salary',
			'median_salary_currency_ref_id' => 'Median Salary Currency Ref',
			'high_domestic_salary' => 'High Domestic Salary',
			'high_domestic_salary_currency_ref_id' => 'High Domestic Salary Currency Ref',
			'high_international_salary' => 'High International Salary',
			'high_international_salary_currency_ref_id' => 'High International Salary Currency Ref',
			'critical_high_percent' => 'Critical High Percent',
			'critical_medium_percent' => 'Critical Medium Percent',
			'critical_low_percent' => 'Critical Low Percent',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'additional_comments' => 'Additional Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_id',$this->course_id,true);
		$criteria->compare('course_code',$this->course_code,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('college_ref_id',$this->college_ref_id);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('department_old_id',$this->department_old_id);
		$criteria->compare('subject_ref_id',$this->subject_ref_id);
		$criteria->compare('course_subject_ref_id',$this->course_subject_ref_id);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('course_slug_name',$this->course_slug_name,true);
		$criteria->compare('course_desc',$this->course_desc,true);
		$criteria->compare('course_level',$this->course_level,true);
		$criteria->compare('degree_granted_ref_id',$this->degree_granted_ref_id);
		$criteria->compare('popular_degree_ref_id',$this->popular_degree_ref_id);
		$criteria->compare('course_duration',$this->course_duration,true);
		$criteria->compare('course_duration_old',$this->course_duration_old,true);
		$criteria->compare('duration_commentary',$this->duration_commentary,true);
		$criteria->compare('course_mode',$this->course_mode,true);
		$criteria->compare('admission_page_link',$this->admission_page_link,true);
		$criteria->compare('course_start_date',$this->course_start_date,true);
		$criteria->compare('course_start_date1',$this->course_start_date1,true);
		$criteria->compare('course_start_date2',$this->course_start_date2,true);
		$criteria->compare('course_fees',$this->course_fees);
		$criteria->compare('course_fees_commentary',$this->course_fees_commentary,true);
		$criteria->compare('higher_end_fees',$this->higher_end_fees);
		$criteria->compare('course_page_link',$this->course_page_link,true);
		$criteria->compare('course_ranking',$this->course_ranking,true);
		$criteria->compare('total_students',$this->total_students);
		$criteria->compare('male_students_percent',$this->male_students_percent);
		$criteria->compare('female_students_percent',$this->female_students_percent);
		$criteria->compare('full_time_per',$this->full_time_per);
		$criteria->compare('part_time_per',$this->part_time_per);
		$criteria->compare('total_applicants',$this->total_applicants);
		$criteria->compare('total_seats_available',$this->total_seats_available);
		$criteria->compare('international_stud_per',$this->international_stud_per,true);
		$criteria->compare('home_region_stud_per',$this->home_region_stud_per,true);
		$criteria->compare('stud_going_high_edu',$this->stud_going_high_edu);
		$criteria->compare('stud_going_high_internat_edu',$this->stud_going_high_internat_edu);
		$criteria->compare('higher_studies_comment',$this->higher_studies_comment,true);
		$criteria->compare('placement_per',$this->placement_per,true);
		$criteria->compare('test_needed',$this->test_needed,true);
		$criteria->compare('cut_off_marks',$this->cut_off_marks,true);
		$criteria->compare('top_faculty',$this->top_faculty,true);
		$criteria->compare('summer_intership',$this->summer_intership,true);
		$criteria->compare('applicant_to_offer_ratio',$this->applicant_to_offer_ratio);
		$criteria->compare('applicant_to_enrolment_ratio',$this->applicant_to_enrolment_ratio);
		$criteria->compare('uni_acceptance_rate',$this->uni_acceptance_rate,true);
		$criteria->compare('vintage',$this->vintage);
		$criteria->compare('application_start_date',$this->application_start_date,true);
		$criteria->compare('application_last_date',$this->application_last_date,true);
		$criteria->compare('application_sale_last_date',$this->application_sale_last_date,true);
		$criteria->compare('professors_review',$this->professors_review,true);
		$criteria->compare('stud_reviews_of_professor',$this->stud_reviews_of_professor,true);
		$criteria->compare('admission_difficulty',$this->admission_difficulty,true);
		$criteria->compare('student_rating',$this->student_rating,true);
		$criteria->compare('is_twining',$this->is_twining,true);
		$criteria->compare('twining_comment',$this->twining_comment,true);
		$criteria->compare('admission_quota',$this->admission_quota,true);
		$criteria->compare('degree_granted',$this->degree_granted,true);
		$criteria->compare('dept_associated',$this->dept_associated,true);
		$criteria->compare('uni_insights',$this->uni_insights,true);
		$criteria->compare('teaching_pattern',$this->teaching_pattern,true);
		$criteria->compare('syllabus',$this->syllabus,true);
		$criteria->compare('number_of_intakes',$this->number_of_intakes,true);
		$criteria->compare('application_process',$this->application_process,true);
		$criteria->compare('application_form_url',$this->application_form_url,true);
		$criteria->compare('is_scholarship',$this->is_scholarship,true);
		$criteria->compare('scholarship_availability',$this->scholarship_availability,true);
		$criteria->compare('scholarship_commentary',$this->scholarship_commentary,true);
		$criteria->compare('eligibility_commentary',$this->eligibility_commentary,true);
		$criteria->compare('hostel_availabilty',$this->hostel_availabilty,true);
		$criteria->compare('placement_commentary',$this->placement_commentary,true);
		$criteria->compare('placement_specialisation',$this->placement_specialisation,true);
		$criteria->compare('placement_percent',$this->placement_percent);
		$criteria->compare('low_sal_range',$this->low_sal_range,true);
		$criteria->compare('low_sal_range_currency_ref_id',$this->low_sal_range_currency_ref_id);
		$criteria->compare('high_sal_range',$this->high_sal_range,true);
		$criteria->compare('high_sal_range_currency_ref_id',$this->high_sal_range_currency_ref_id);
		$criteria->compare('avg_salary',$this->avg_salary,true);
		$criteria->compare('avg_salary_currency_ref_id',$this->avg_salary_currency_ref_id);
		$criteria->compare('median_salary',$this->median_salary,true);
		$criteria->compare('median_salary_currency_ref_id',$this->median_salary_currency_ref_id);
		$criteria->compare('high_domestic_salary',$this->high_domestic_salary,true);
		$criteria->compare('high_domestic_salary_currency_ref_id',$this->high_domestic_salary_currency_ref_id);
		$criteria->compare('high_international_salary',$this->high_international_salary,true);
		$criteria->compare('high_international_salary_currency_ref_id',$this->high_international_salary_currency_ref_id);
		$criteria->compare('critical_high_percent',$this->critical_high_percent);
		$criteria->compare('critical_medium_percent',$this->critical_medium_percent);
		$criteria->compare('critical_low_percent',$this->critical_low_percent);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('additional_comments',$this->additional_comments,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}