<?php

/**
/*
 * @author Shastry Chamarthi
 * @package application.models 
 * 
 * BaseTblUserInterest is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_user_interest".
 *
 * The followings are the available columns in table 'tbl_user_interest':
 * @property integer $id
 * @property string $user_ref_id
 * @property integer $interest_id
 * @property integer $interest_level
 * @property string $interest_type
 * @property string $interest_hobbies
 * @property integer $user_interest_ref_id
 * @property integer $user_interest_type_ref_id
 * @property integer $user_interest_level_ref_id
 * @property string $awards_achievements
 * @property string $voluntary_work
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property LookupUserInterest $userInterestRef
 * @property LookupUserInterestType $userInterestTypeRef
 * @property LookupUserInterestLevel $userInterestLevelRef
 * @property LookupInterest $interest
 */
class BaseTblUserInterest extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblUserInterest the static model class
	 */
	 
	public $detail = 'This is the default text';
	
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_user_interest';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
            array('user_interest_ref_id, user_interest_type_ref_id, user_interest_level_ref_id, interest_id, interest_level', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('interest_type', 'length', 'max'=>11),
			array('added_on', 'default', 'value'=>date('Y-m-d H:i:s')),
			array('interest_hobbies, awards_achievements, voluntary_work, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
            array('id, user_ref_id, user_interest_ref_id, user_interest_type_ref_id, user_interest_level_ref_id, interest_id, interest_level, interest_type, interest_hobbies, awards_achievements, voluntary_work, added_on', 'safe', 'on'=>'search'),
			
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
            'userInterestRef' => array(self::BELONGS_TO, 'LookupUserInterest', 'user_interest_ref_id'),
            'userInterestTypeRef' => array(self::BELONGS_TO, 'LookupUserInterestType', 'user_interest_type_ref_id'),
            'userInterestLevelRef' => array(self::BELONGS_TO, 'LookupUserInterestLevel', 'user_interest_level_ref_id'),
            'interest' => array(self::BELONGS_TO, 'LookupInterest', 'interest_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'user_ref_id' => 'User Ref',
            'user_interest_ref_id' => 'User Interest Ref',
            'user_interest_type_ref_id' => 'User Interest Type Ref',
            'user_interest_level_ref_id' => 'User Interest Level Ref',
			'interest_id' => 'Interest',
			'interest_level' => 'Interest Level',
			'interest_type' => 'Interest Type',
			'interest_hobbies' => 'Interest and Hobbies',
			'awards_achievements' => 'Awards Achievements',
			'voluntary_work' => 'Voluntary Work',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
        $criteria->compare('user_interest_ref_id',$this->user_interest_ref_id);
        $criteria->compare('user_interest_type_ref_id',$this->user_interest_type_ref_id);
        $criteria->compare('user_interest_level_ref_id',$this->user_interest_level_ref_id);
		$criteria->compare('interest_id',$this->interest_id);
		$criteria->compare('interest_level',$this->interest_level);
		$criteria->compare('interest_type',$this->interest_type,true);
		$criteria->compare('interest_hobbies',$this->interest_hobbies,true);
		$criteria->compare('awards_achievements',$this->awards_achievements,true);
		$criteria->compare('voluntary_work',$this->voluntary_work,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}