<?php

/**
/*
 * @author Asif Ali M
 * @package application.models
 *
 * BaseTblUserMaster is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_user_master".
 *
 * The followings are the available columns in table 'tbl_user_master':
 * @property string $user_id
 * @property string $login_ref_id
 * @property integer $membership_ref_id
 * @property string $uno
 * @property string $user_photo
 * @property string $first_name
 * @property string $middle_name
 * @property string $last_name
 * @property string $father_first_name
 * @property string $father_last_name
 
 * @property string $mother_first_name
 * @property string $mother_last_name
 * @property string $guardian_first_name
 * @property string $guardian_last_name
 * @property string $address1
 * @property string $address2
 * @property integer $city_ref_id
 * @property integer $state_ref_id
 * @property string $city
 * @property string $state
 * @property integer $country_ref_id
 * @property string $post_code
 * @property string $present_class
 * @property string $class_status
 * @property integer $present_board_ref_id
 * @property integer $school_ref_id
 * @property integer $passout_year
 * @property integer $passout_month
 * @property string $dob
 * @property string $gender
 * @property integer $ethnicity_ref_id
 * @property integer $family_income_ref_id
 * @property integer $primary_financing_ref_id
 * @property integer $scholarship_importance_ref_id
 * @property integer $reason_study_abroad_ref_id
 * @property string $ps_why_this_subject
 * @property string $ps_leadership
 * @property string $other_activities
 * @property string $introduce_yourself
 * @property integer $redirect_url_ref_id
 * @property integer $profile_status_ref_id
 * @property integer $payment_status_ref_id
 * @property string $is_newsletter_subscribe
 * @property string $added_on
 * @property string $modified_on
 * @property string $new_password
 * @property integer $book_session_count
 * @property string $is_valid_email
 * @property string $profile_complete_date
 * @property integer $critical_percent
 * @property integer $can_contact
 * @property integer $recommended_percent
 * @property string $is_test
 * @property string $get_alert
 *
 * The followings are the available model relations:
 * @property DiCashDebit[] $diCashDebits
 * @property DiProductDebit[] $diProductDebits
 * @property DiPurchaseProfile[] $diPurchaseProfiles
 * @property DiUserAlertMatch[] $diUserAlertMatches
 * @property DiUserEoi[] $diUserEois
 * @property DiUserEoiLog[] $diUserEoiLogs
 * @property EventStudent[] $eventStudents
 * @property LookupWorkplan[] $lookupWorkplans
 * @property Prospect[] $prospects
 * @property SiMilestoneNotes[] $siMilestoneNotes
 * @property SiMilestoneReminder[] $siMilestoneReminders
 * @property StudentAssignedAdvisor[] $studentAssignedAdvisors
 * @property StudentCitizenship[] $studentCitizenships 
 * @property StudentContactNumber[] $studentContactNumbers
 * @property StudentEducation[] $studentEducations
 * @property StudentEntranceExamVendorBranch[] $studentEntranceExamVendorBranches
 * @property StudentHotlead[] $studentHotleads
 * @property StudentIdealList[] $studentIdealLists
 * @property StudentKnownLanguage[] $studentKnownLanguages
 * @property StudentOutplacementSubdepartment[] $studentOutplacementSubdepartments
 * @property StudentPreferredBoard[] $studentPreferredBoards
 * @property StudentPreferredCareer[] $studentPreferredCareers
 * @property StudentPreferredCountry[] $studentPreferredCountries
 * @property StudentHypothesisCountry[] $studentHypothesisCountry
 * @property StudentPreferredCountryLog[] $studentPreferredCountryLogs
 * @property StudentPreferredDepartment[] $studentPreferredDepartments
 * @property StudentHypothesisDepartment[] $studentHypothesisDepartments
 * @property StudentPreferredDepartmentLog[] $studentPreferredDepartmentLogs
 * @property StudentPreferredDuration[] $studentPreferredDurations
 * @property StudentPreferredPeriod[] $studentPreferredPeriods
 * @property StudentPreferredStudyLevel[] $studentPreferredStudyLevels
 * @property StudentPreferredSubject[] $studentPreferredSubjects
 * @property StudentPreferredUniversity[] $studentPreferredUniversities
 * @property StudentQuestion[] $studentQuestions
 * @property StudentUpgradeLog[] $studentUpgradeLogs
 * @property StudentUploadMasterList[] $studentUploadMasterLists
 * @property StudentWorkplan[] $studentWorkplans
 * @property StudentWorkplanAdditionalActivity[] $studentWorkplanAdditionalActivities
 * @property TaskStudent[] $taskStudents
 * @property TblBlogComments[] $tblBlogComments
 * @property TblInteractionDetails[] $tblInteractionDetails
 * @property TblSiStudents[] $tblSiStudents
 * @property TblUknow[] $tblUknows
 * @property TblUserCourses[] $tblUserCourses
 * @property TblUserDocuments[] $tblUserDocuments
 * @property TblUserInterest[] $tblUserInterests
 * @property LookupPrimaryFinancing $primaryFinancingRef
 * @property TblCityMaster $cityRef
 * @property TblCountryMaster $countryRef
 * @property MasterEthnicity $ethnicityRef
 * @property MasterFamilyIncome $familyIncomeRef
 * @property LoginMaster $loginRef
 * @property LookupMembership $membershipRef
 * @property LookupPaymentStatus $paymentStatusRef
 * @property LookupProfileStatus $profileStatusRef
 * @property LookupReasonStudyAbroad $reasonStudyAbroadRef
 * @property MasterScholarshipImportance $scholarshipImportanceRef
 * @property LookupSchool $schoolRef
 * @property TblState $stateRef
 * @property LookupUrl $redirectUrlRef
 * @property LookupBoard $presentBoardRef
 * @property TblUserProfCriticalCompletion $tblUserProfCriticalCompletion
 * @property TblUserProfRecommendedCompletion $tblUserProfRecommendedCompletion
 * @property TblUserReferal[] $tblUserReferals
 * @property TblUserSaveSearch[] $tblUserSaveSearches
 * @property TblUserUmapResult[] $tblUserUmapResults
 * @property TblUserWorkExperience[] $tblUserWorkExperiences
 * @property TblUsersStatusFlag[] $tblUsersStatusFlags
 * @property TblUniversityMaster[] $tblUniversityMasters
 * @property UmapUserPoints[] $umapUserPoints
 * @property UniAnalytic[] $uniAnalytics
 * @property UserDataPoint[] $userDataPoints
 * @property UserMilestone[] $userMilestones
 * @property UserMilestoneSuggestion[] $userMilestoneSuggestions
 * @property WorkshopSiGroupStudent[] $workshopSiGroupStudents
 * @property WorkshopSiGroupStudentFeedback[] $workshopSiGroupStudentFeedbacks
 */
class BaseTblUserMaster extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblUserMaster the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_user_master';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('passout_year, passout_month', 'required'),
			array('membership_ref_id, city_ref_id, state_ref_id, country_ref_id, present_board_ref_id, school_ref_id, passout_year, passout_month, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, book_session_count, critical_percent, can_contact, recommended_percent', 'numerical', 'integerOnly'=>true),
			array('login_ref_id', 'length', 'max'=>10),
			array('uno', 'length', 'max'=>11),
			array('user_photo', 'length', 'max'=>255),
			array('first_name, middle_name, last_name', 'length', 'max'=>100),
			array('father_first_name, father_last_name, mother_first_name, mother_last_name, guardian_first_name, guardian_last_name', 'length', 'max'=>75),
			//array('address1, address2, city, state', 'length', 'max'=>200),
                        array('address1, address2, other_activities', 'length', 'max'=>200),
			array('post_code', 'length', 'max'=>12),
			array('present_class', 'length', 'max'=>2),
			array('class_status', 'length', 'max'=>9),
			array('gender, is_newsletter_subscribe, new_password, is_valid_email, is_test, get_alert', 'length', 'max'=>1),
			array('dob, ps_why_this_subject, ps_leadership, other_activities, introduce_yourself, added_on, modified_on, profile_complete_date,exams_required,know_your_subjects', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_id, login_ref_id, membership_ref_id, uno, user_photo, first_name, middle_name, last_name, father_first_name, father_last_name, mother_first_name, mother_last_name, guardian_first_name, guardian_last_name, address1, address2, city_ref_id, state_ref_id, country_ref_id, post_code, present_class, class_status, present_board_ref_id, school_ref_id, passout_year, passout_month, dob, gender, ethnicity_ref_id, family_income_ref_id, primary_financing_ref_id, scholarship_importance_ref_id, reason_study_abroad_ref_id, ps_why_this_subject, ps_leadership, other_activities, introduce_yourself, redirect_url_ref_id, profile_status_ref_id, payment_status_ref_id, is_newsletter_subscribe, added_on, modified_on, new_password, book_session_count, is_valid_email, profile_complete_date, critical_percent, can_contact, recommended_percent, is_test, get_alert, class_change,is_visited_school,is_location_entered', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diCashDebits' => array(self::HAS_MANY, 'DiCashDebit', 'user_ref_id'),
			'diProductDebits' => array(self::HAS_MANY, 'DiProductDebit', 'user_ref_id'),
			'diPurchaseProfiles' => array(self::HAS_MANY, 'DiPurchaseProfile', 'user_ref_id'),
			'diUserAlertMatches' => array(self::HAS_MANY, 'DiUserAlertMatch', 'user_ref_id'),
            'diUserCriteriaMatches' => array(self::HAS_MANY, 'DiUserCriteriaMatch', 'user_ref_id'),
            'diUserCriteriaShortlists' => array(self::HAS_MANY, 'DiUserCriteriaShortlist', 'user_ref_id'),
			'diUserEois' => array(self::HAS_MANY, 'DiUserEoi', 'user_ref_id'),
			'diUserEoiLogs' => array(self::HAS_MANY, 'DiUserEoiLog', 'user_ref_id'),
            'diUserRefunds' => array(self::HAS_MANY, 'DiUserRefund', 'user_ref_id'),
			'eventStudents' => array(self::HAS_MANY, 'EventStudent', 'user_ref_id'),
			'lookupWorkplans' => array(self::HAS_MANY, 'LookupWorkplan', 'user_ref_id'),
			'prospects' => array(self::HAS_MANY, 'Prospect', 'user_ref_id'),
			'siMilestoneNotes' => array(self::HAS_MANY, 'SiMilestoneNotes', 'user_ref_id'),
			'siMilestoneReminders' => array(self::HAS_MANY, 'SiMilestoneReminder', 'user_ref_id'),
			'studentAssignedAdvisors' => array(self::HAS_MANY, 'StudentAssignedAdvisor', 'user_ref_id'),
                        'studentCitizenships' => array(self::HAS_MANY, 'StudentCitizenship', 'user_ref_id'),                    
			'studentContactNumbers' => array(self::HAS_MANY, 'StudentContactNumber', 'user_ref_id'),
            'studentEducations' => array(self::HAS_MANY, 'StudentEducation', 'user_ref_id'),
			'studentEntranceExamVendorBranches' => array(self::HAS_MANY, 'StudentEntranceExamVendorBranch', 'user_ref_id'),
			'studentHotleads' => array(self::HAS_MANY, 'StudentHotlead', 'user_ref_id'),
			'studentIdealLists' => array(self::HAS_MANY, 'StudentIdealList', 'user_ref_id'),
			'studentKnownLanguages' => array(self::HAS_MANY, 'StudentKnownLanguage', 'user_ref_id'),
			'studentOutplacementSubdepartments' => array(self::HAS_MANY, 'StudentOutplacementSubdepartment', 'user_ref_id'),
            'studentOutplacementSColleges' => array(self::HAS_MANY, 'StudentOutplacementColleges', 'user_ref_id'),
			'studentPreferredBoards' => array(self::HAS_MANY, 'StudentPreferredBoard', 'user_ref_id'),
			'studentPreferredCareers' => array(self::HAS_MANY, 'StudentPreferredCareer', 'user_ref_id'),
			'studentPreferredCountries' => array(self::HAS_MANY, 'StudentPreferredCountry', 'user_ref_id','order'
            => 'studentPreferredCountries.preference_order'),
            'studentHypothesisCountries' => array(self::HAS_MANY, 'StudentHypothesisCountry', 'user_ref_id', 'order'
            => 'studentHypothesisCountries.preference_order'),
			'studentPreferredCountryLogs' => array(self::HAS_MANY, 'StudentPreferredCountryLog', 'user_ref_id'),
			'studentPreferredDepartments' => array(self::HAS_MANY, 'StudentPreferredDepartment', 'user_ref_id', 'order'
            => 'studentPreferredDepartments.preference_order'),
            'studentHypothesisDepartments' => array(self::HAS_MANY, 'StudentHypothesisDepartment', 'user_ref_id', 'order'
            => 'studentHypothesisDepartments.preference_order'),
			'studentPreferredDepartmentLogs' => array(self::HAS_MANY, 'StudentPreferredDepartmentLog', 'user_ref_id'),
			'studentPreferredDurations' => array(self::HAS_MANY, 'StudentPreferredDuration', 'user_ref_id'),
			//'studentPreferredPeriods' => array(self::HAS_MANY, 'StudentPreferredPeriod', 'user_ref_id'),
			'studentPreferredStudyLevels' => array(self::HAS_MANY, 'StudentPreferredStudyLevel', 'user_ref_id'),
			'studentPreferredSubjects' => array(self::HAS_MANY, 'StudentPreferredSubject', 'user_ref_id'),
			'studentPreferredUniversities' => array(self::HAS_MANY, 'StudentPreferredUniversity', 'user_ref_id'),
			'studentQuestions' => array(self::HAS_MANY, 'StudentQuestion', 'user_ref_id'),
            'studentShortlistUniversities' => array(self::HAS_MANY, 'StudentShortlistUniversity', 'user_ref_id'),
			'studentUpgradeLogs' => array(self::HAS_MANY, 'StudentUpgradeLog', 'user_ref_id'),
			'studentUploadMasterLists' => array(self::HAS_MANY, 'StudentUploadMasterList', 'user_ref_id'),
			'studentWorkplans' => array(self::HAS_MANY, 'StudentWorkplan', 'user_ref_id'),
			'studentWorkplanAdditionalActivities' => array(self::HAS_MANY, 'StudentWorkplanAdditionalActivity', 'user_ref_id'),
			'taskStudents' => array(self::HAS_MANY, 'TaskStudent', 'student_ref_id'),
			'tblBlogComments' => array(self::HAS_MANY, 'TblBlogComments', 'user_ref_id'),
			'tblInteractionDetails' => array(self::HAS_MANY, 'TblInteractionDetails', 'user_ref_id'),
			'tblSiStudents' => array(self::HAS_MANY, 'TblSiStudents', 'user_ref_id'),
			'tblUknows' => array(self::HAS_MANY, 'TblUknow', 'user_ref_id'),
			'tblUserCourses' => array(self::HAS_MANY, 'TblUserCourses', 'user_ref_id'),
			'tblUserDocuments' => array(self::HAS_MANY, 'TblUserDocuments', 'user_ref_id'),
			'tblUserInterests' => array(self::HAS_MANY, 'TblUserInterest', 'user_ref_id'),
			'primaryFinancingRef' => array(self::BELONGS_TO, 'LookupPrimaryFinancing', 'primary_financing_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
                        'city' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'ethnicityRef' => array(self::BELONGS_TO, 'MasterEthnicity', 'ethnicity_ref_id'),
			'familyIncomeRef' => array(self::BELONGS_TO, 'MasterFamilyIncome', 'family_income_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
			'membershipRef' => array(self::BELONGS_TO, 'LookupMembership', 'membership_ref_id'),
			'paymentStatusRef' => array(self::BELONGS_TO, 'LookupPaymentStatus', 'payment_status_ref_id'),
			'profileStatusRef' => array(self::BELONGS_TO, 'LookupProfileStatus', 'profile_status_ref_id'),
			'reasonStudyAbroadRef' => array(self::BELONGS_TO, 'LookupReasonStudyAbroad', 'reason_study_abroad_ref_id'),
			'scholarshipImportanceRef' => array(self::BELONGS_TO, 'MasterScholarshipImportance', 'scholarship_importance_ref_id'),
			'schoolRef' => array(self::BELONGS_TO, 'LookupSchool', 'school_ref_id'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
                        'state' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
			'redirectUrlRef' => array(self::BELONGS_TO, 'LookupUrl', 'redirect_url_ref_id'),
			'presentBoardRef' => array(self::BELONGS_TO, 'LookupBoard', 'present_board_ref_id'),
			'tblUserProfCriticalCompletion' => array(self::HAS_ONE, 'TblUserProfCriticalCompletion', 'user_ref_id'),
			'tblUserProfRecommendedCompletion' => array(self::HAS_ONE, 'TblUserProfRecommendedCompletion', 'user_ref_id'),
			'tblUserReferals' => array(self::HAS_MANY, 'TblUserReferal', 'user_ref_id'),
			'tblUserSaveSearches' => array(self::HAS_MANY, 'TblUserSaveSearch', 'user_ref_id'),
			'tblUserUmapResults' => array(self::HAS_MANY, 'TblUserUmapResult', 'user_ref_id'),
			'tblUserWorkExperiences' => array(self::HAS_MANY, 'TblUserWorkExperience', 'user_ref_id'),
			'tblUsersStatusFlags' => array(self::HAS_MANY, 'TblUsersStatusFlag', 'user_ref_id'),
			'tblUniversityMasters' => array(self::MANY_MANY, 'TblUniversityMaster', 'temp_cutoff_overall_marks(user_ref_id, uni_ref_id)'),
			'umapUserPoints' => array(self::HAS_MANY, 'UmapUserPoints', 'user_ref_id'),
			'uniAnalytics' => array(self::HAS_MANY, 'UniAnalytic', 'user_ref_id'),
            'universityIdealListLogs' => array(self::HAS_MANY, 'UniversityIdealListLog', 'user_ref_id'),
			'userDataPoints' => array(self::HAS_MANY, 'UserDataPoint', 'user_ref_id'),
            'userEntranceExams' => array(self::HAS_MANY, 'UserEntranceExam', 'user_ref_id'),
            'userIdealLists' => array(self::HAS_MANY, 'UserIdealList', 'user_ref_id'),
			'userMilestones' => array(self::HAS_MANY, 'UserMilestone', 'user_ref_id'),
			'userMilestoneSuggestions' => array(self::HAS_MANY, 'UserMilestoneSuggestion', 'user_ref_id'),
            'userScholarships' => array(self::HAS_MANY, 'UserScholarship', 'user_ref_id'),
			'workshopSiGroupStudents' => array(self::HAS_MANY, 'WorkshopSiGroupStudent', 'user_ref_id'),
			'workshopSiGroupStudentFeedbacks' => array(self::HAS_MANY, 'WorkshopSiGroupStudentFeedback', 'user_ref_id'),



                        //Inherit the features of OutPlacement Relations
                       'diSearchResults' => array(self::HAS_MANY, 'DiSearchResult', 'user_ref_id'),
                       'gatewayPayments' => array(self::HAS_MANY, 'GatewayPayment', 'added_by'),
                       'studentKnownLanguages' => array(self::HAS_MANY, 'StudentKnownLanguage', 'user_ref_id'),
                       'studentPreferredCareers' => array(self::HAS_MANY, 'StudentPreferredCareer', 'user_ref_id'),
                       'studentPreferredCountries' => array(self::HAS_MANY, 'StudentPreferredCountry', 'user_ref_id', 'order'
=> 'studentPreferredCountries.preference_order'),
                        'studentHypothesisCountries' => array(self::HAS_MANY, 'StudentHypothesisCountry', 'user_ref_id', 'order'
                        => 'studentHypothesisCountries.preference_order'),
                       'studentPreferredDepartments' => array(self::HAS_MANY, 'StudentPreferredDepartment', 'user_ref_id', 'order'
                       => 'studentPreferredDepartments.preference_order'),
                       'studentHypothesisDepartments' => array(self::HAS_MANY, 'StudentHypothesisDepartment', 'user_ref_id', 'order'
                       => 'studentHypothesisDepartments.preference_order'),
                       'studentPreferredDurations' => array(self::HAS_MANY, 'StudentPreferredDuration', 'user_ref_id'),
                       'studentPreferredPeriods' => array(self::HAS_MANY, 'StudentPreferredPeriod', 'user_ref_id', 'order'=>'studentPreferredPeriods.year ASC, studentPreferredPeriods.period_ref_id ASC'),
                       'studentPreferredStudyLevels' => array(self::HAS_MANY, 'StudentPreferredStudyLevel', 'user_ref_id'),
                       'studentPreferredUniversities' => array(self::HAS_MANY, 'StudentPreferredUniversity', 'user_ref_id'),
                       'studentQuestions' => array(self::HAS_MANY, 'StudentQuestion', 'user_ref_id'),
                       'paymentStatusRef' => array(self::BELONGS_TO, 'LookupPaymentStatus', 'payment_status_ref_id'),
                       'profileStatusRef' => array(self::BELONGS_TO, 'LookupProfileStatus', 'profile_status_ref_id'),
                       'schoolRef' => array(self::BELONGS_TO, 'LookupSchool', 'school_ref_id'),
                       'redirectUrlRef' => array(self::BELONGS_TO, 'LookupUrl', 'redirect_url_ref_id'),
                       'presentBoardRef' => array(self::BELONGS_TO, 'LookupBoard', 'present_board_ref_id'),
                       'studentEntranceExamVendorBranches' => array(self::HAS_MANY, 'StudentEntranceExamVendorBranch',
'user_ref_id'),
                       'appliedUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity', 'user_ref_id'),
                       'appliedAspirationalUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity',
'user_ref_id', 'condition' => "appliedAspirationalUniversities.list_type = '" . StudentIdealList::TYPE_ASPIRATIONAL . "'"),
                       'appliedBestFitUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity', 'user_ref_id',
'condition' => "appliedBestFitUniversities.list_type = '" . StudentIdealList::TYPE_BEST_FIT . "'"),
                       'appliedSafeUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity', 'user_ref_id',
'condition' => "appliedSafeUniversities.list_type = '" . StudentIdealList::TYPE_SAFE . "'"),
                       'admissionReceivedUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity',
'user_ref_id', 'condition' => "admissionReceivedUniversities.uni_type = '" .
StudentOutplacementUniversity::TYPE_RECEIVED_ADMISSION . "'"),
                       'admissionReceivedAspirationalUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity',
'user_ref_id', 'condition' => "admissionReceivedAspirationalUniversities.list_type = '" . StudentIdealList::TYPE_ASPIRATIONAL
. "' and admissionReceivedAspirationalUniversities.uni_type = '" . StudentOutplacementUniversity::TYPE_RECEIVED_ADMISSION .
"'"),
                       'admissionReceivedBestFitUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity',
'user_ref_id', 'condition' => "admissionReceivedBestFitUniversities.list_type = '" . StudentIdealList::TYPE_BEST_FIT . "' and
admissionReceivedBestFitUniversities.uni_type = '" . StudentOutplacementUniversity::TYPE_RECEIVED_ADMISSION . "'"),
                       'admissionReceivedSafeUniversities' => array(self::HAS_MANY, 'StudentOutplacementUniversity',
'user_ref_id', 'condition' => "admissionReceivedSafeUniversities.list_type = '" . StudentIdealList::TYPE_SAFE . "' and
admissionReceivedSafeUniversities.uni_type = '" . StudentOutplacementUniversity::TYPE_RECEIVED_ADMISSION . "'"),
                       'joinedUniversity' => array(self::HAS_ONE, 'StudentOutplacementUniversity', 'user_ref_id', 'condition'
=> "joinedUniversity.uni_type = '" . StudentOutplacementUniversity::TYPE_JOINED . "'"),
                       'outplacementDepartment' => array(self::HAS_ONE, 'StudentOutplacementSubdepartment', 'user_ref_id'),
                       'tbluniversitymaster' => array(self::MANY_MANY, 'TblUniversityMaster', 'temp_cutoff_overall_marks
(user_ref_id, uni_ref_id)'),
                        'userEntranceExam' => array(self::HAS_MANY, 'UserEntranceExam', 'user_ref_id'),
                        'psychometricTest' => array(self::HAS_ONE, 'PsychometricTest', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_id' => 'User',
			'login_ref_id' => 'Login Ref',
			'membership_ref_id' => 'Membership Ref',
			'uno' => 'Uno',
			'user_photo' => 'User Photo',
			'first_name' => 'First Name',
			'middle_name' => 'Middle Name',
			'last_name' => 'Last Name',
			'father_first_name' => 'Father First Name',
			'father_last_name' => 'Father Last Name',
			'mother_first_name' => 'Mother First Name',
			'mother_last_name' => 'Mother Last Name',
            'guardian_first_name' => 'Guardian First Name',
            'guardian_last_name' => 'Guardian Last Name',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'city_ref_id' => 'City Ref',
			'state_ref_id' => 'State Ref',
			'country_ref_id' => 'Country Ref',
			'post_code' => 'Post Code',
			'present_class' => 'Present Class',
			'class_status' => 'Class Status',
			'present_board_ref_id' => 'Present Board Ref',
			'school_ref_id' => 'School Ref',
			'passout_year' => 'Passout Year',
			'passout_month' => 'Passout Month',
			'dob' => 'Dob',
			'gender' => 'Gender',
			'ethnicity_ref_id' => 'Ethnicity Ref',
			'family_income_ref_id' => 'Family Income Ref',
			'primary_financing_ref_id' => 'Primary Financing Ref',
			'scholarship_importance_ref_id' => 'Scholarship Importance Ref',
			'reason_study_abroad_ref_id' => 'Reason Study Abroad Ref',
			'ps_why_this_subject' => 'Ps Why This Subject',
			'ps_leadership' => 'Ps Leadership',
            'other_activities' => 'Other Activities',
			'introduce_yourself' => 'Introduce Yourself',
			'redirect_url_ref_id' => 'Redirect Url Ref',
			'profile_status_ref_id' => 'Profile Status Ref',
			'payment_status_ref_id' => 'Payment Status Ref',
			'is_newsletter_subscribe' => 'Is Newsletter Subscribe',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'new_password' => 'New Password',
			'book_session_count' => 'Book Session Count',
			'is_valid_email' => 'Is Valid Email',
			'profile_complete_date' => 'Profile Complete Date',
			'critical_percent' => 'Critical Percent',
            'can_contact' => 'Can Contact',
            'recommended_percent' => 'Recommended Percent',
            'is_test' => 'Is Test',
            'get_alert' => 'Get Alert',
			'signup_source_ref_id'=>'Signup Source Ref Id' 
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_id',$this->user_id,true);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('membership_ref_id',$this->membership_ref_id);
		$criteria->compare('uno',$this->uno,true);
		$criteria->compare('user_photo',$this->user_photo,true);
		$criteria->compare('first_name',$this->first_name,true);
		$criteria->compare('middle_name',$this->middle_name,true);
		$criteria->compare('last_name',$this->last_name,true);
		$criteria->compare('father_first_name',$this->father_first_name,true);
		$criteria->compare('father_last_name',$this->father_last_name,true);
		$criteria->compare('mother_first_name',$this->mother_first_name,true);
		$criteria->compare('mother_last_name',$this->mother_last_name,true);
        $criteria->compare('guardian_first_name',$this->guardian_first_name,true);
        $criteria->compare('guardian_last_name',$this->guardian_last_name,true);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('post_code',$this->post_code,true);
		$criteria->compare('present_class',$this->present_class,true);
		$criteria->compare('class_status',$this->class_status,true);
		$criteria->compare('present_board_ref_id',$this->present_board_ref_id);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('passout_year',$this->passout_year);
		$criteria->compare('passout_month',$this->passout_month);
		$criteria->compare('dob',$this->dob,true);
		$criteria->compare('gender',$this->gender,true);
		$criteria->compare('ethnicity_ref_id',$this->ethnicity_ref_id);
		$criteria->compare('family_income_ref_id',$this->family_income_ref_id);
		$criteria->compare('primary_financing_ref_id',$this->primary_financing_ref_id);
		$criteria->compare('scholarship_importance_ref_id',$this->scholarship_importance_ref_id);
		$criteria->compare('reason_study_abroad_ref_id',$this->reason_study_abroad_ref_id);
		$criteria->compare('ps_why_this_subject',$this->ps_why_this_subject,true);
		$criteria->compare('ps_leadership',$this->ps_leadership,true);
        $criteria->compare('other_activities',$this->other_activities,true);
		$criteria->compare('introduce_yourself',$this->introduce_yourself,true);
		$criteria->compare('redirect_url_ref_id',$this->redirect_url_ref_id);
		$criteria->compare('profile_status_ref_id',$this->profile_status_ref_id);
		$criteria->compare('payment_status_ref_id',$this->payment_status_ref_id);
		$criteria->compare('is_newsletter_subscribe',$this->is_newsletter_subscribe,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('new_password',$this->new_password,true);
		$criteria->compare('book_session_count',$this->book_session_count);
		$criteria->compare('is_valid_email',$this->is_valid_email,true);
		$criteria->compare('profile_complete_date',$this->profile_complete_date,true);
		$criteria->compare('critical_percent',$this->critical_percent);
        $criteria->compare('can_contact',$this->can_contact);
		$criteria->compare('recommended_percent',$this->recommended_percent);
        $criteria->compare('is_test',$this->is_test,true);
        $criteria->compare('get_alert',$this->get_alert,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}