<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTblUserProfCriticalCompletion is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_user_prof_critical_completion".
 *
 * The followings are the available columns in table 'tbl_user_prof_critical_completion':
 * @property string $user_ref_id
 * @property integer $country
 * @property integer $likely_start_period
 * @property integer $study_level
 * @property integer $preferred_course_duration
 * @property integer $intended_subjects
 * @property integer $name
 * @property integer $dob
 * @property integer $gender
 * @property integer $phone
 * @property integer $citizenship
 * @property integer $edu_study_level
 * @property integer $school_name
 * @property integer $completion_year
 * @property integer $board
 * @property integer $curriculum
 * @property integer $career
 * @property integer $like_subjects
 * @property integer $interest
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseTblUserProfCriticalCompletion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TblUserProfCriticalCompletion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_user_prof_critical_completion';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id', 'required'),
			array('country, likely_start_period, study_level, preferred_course_duration, intended_subjects, name, dob, gender, phone, citizenship, edu_study_level, school_name, completion_year, board, curriculum, career, like_subjects, interest', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_ref_id, country, likely_start_period, study_level, preferred_course_duration, intended_subjects, name, dob, gender, phone, citizenship, edu_study_level, school_name, completion_year, board, curriculum, career, like_subjects, interest, overall_marks', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_ref_id' => 'User Ref',
			'country' => 'Country',
			'likely_start_period' => 'Likely Start Period',
			'study_level' => 'Study Level',
			'preferred_course_duration' => 'Preferred Course Duration',
			'intended_subjects' => 'Intended Subjects',
			'name' => 'Name',
			'dob' => 'Dob',
			'gender' => 'Gender',
			'phone' => 'Phone',
			'citizenship' => 'Citizenship',
			'edu_study_level' => 'Edu Study Level',
			'school_name' => 'School Name',
			'completion_year' => 'Completion Year',
			'board' => 'Board',
			'curriculum' => 'Curriculum',
			'career' => 'Career',
			'like_subjects' => 'Like Subjects',
			'interest' => 'Interest',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('country',$this->country);
		$criteria->compare('likely_start_period',$this->likely_start_period);
		$criteria->compare('study_level',$this->study_level);
		$criteria->compare('preferred_course_duration',$this->preferred_course_duration);
		$criteria->compare('intended_subjects',$this->intended_subjects);
		$criteria->compare('name',$this->name);
		$criteria->compare('dob',$this->dob);
		$criteria->compare('gender',$this->gender);
		$criteria->compare('phone',$this->phone);
		$criteria->compare('citizenship',$this->citizenship);
		$criteria->compare('edu_study_level',$this->edu_study_level);
		$criteria->compare('school_name',$this->school_name);
		$criteria->compare('completion_year',$this->completion_year);
		$criteria->compare('board',$this->board);
		$criteria->compare('curriculum',$this->curriculum);
		$criteria->compare('career',$this->career);
		$criteria->compare('like_subjects',$this->like_subjects);
		$criteria->compare('interest',$this->interest);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}