<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTopPopularCollege is autogenerate by UniModel generator
 *
 * This is the model class for table "top_popular_college".
 *
 * The followings are the available columns in table 'top_popular_college':
 * @property string $top_popular_college_id
 * @property integer $department_ref_id
 * @property integer $country_ref_id
 * @property integer $top_college_ref_id
 * @property integer $popular_college_ref_id
 * @property integer $top_college_rank
 * @property integer $is_active
 * @property string $added_by
 *
 * The followings are the available model relations:
 * @property LookupDepartment $departmentRef
 * @property TblCountryMaster $countryRef
 * @property TblUniversityMaster $topCollege
 * @property TblUniversityMaster $popularCollege
 */
class BaseTopPopularCollege extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TopPopularCollege the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'top_popular_college';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('department_ref_id, country_ref_id, top_college_ref_id, popular_college_ref_id, added_by', 'required'),
			array('department_ref_id, country_ref_id, top_college_ref_id, popular_college_ref_id, top_college_rank, is_active', 'numerical', 'integerOnly'=>true),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('top_popular_college_id, department_ref_id, country_ref_id, top_college_ref_id, popular_college_ref_id, top_college_rank, is_active, added_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'topCollege' => array(self::BELONGS_TO, 'TblUniversityMaster', 'top_college_ref_id'),
			'popularCollege' => array(self::BELONGS_TO, 'TblUniversityMaster', 'popular_college_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'top_popular_college_id' => 'Top Popular College',
			'department_ref_id' => 'Department Ref',
			'country_ref_id' => 'Country Ref',
			'top_college_ref_id' => 'Top College Ref',
			'popular_college_ref_id' => 'Popular College Ref',
			'top_college_rank' => 'Top College Rank',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('top_popular_college_id',$this->top_popular_college_id,true);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('top_college_ref_id',$this->top_college_ref_id);
		$criteria->compare('popular_college_ref_id',$this->popular_college_ref_id);
		$criteria->compare('top_college_rank',$this->top_college_rank);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_by',$this->added_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}