<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTrainingModule is autogenerate by UniModel generator
 *
 * This is the model class for table "training_module".
 *
 * The followings are the available columns in table 'training_module':
 * @property integer $training_module_id
 * @property integer $training_category_ref_id
 * @property integer $parent_ref_id
 * @property string $module_name
 * @property string $module_description
 * @property integer $course_duration
 * @property integer $assessment_duration
 * @property integer $is_active
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TrainingCategory $trainingCategoryRef
 * @property TrainingModuleSlide[] $trainingModuleSlides
 * @property TrainingUserAssessment[] $trainingUserAssessments
 */
class BaseTrainingModule extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TrainingModule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'training_module';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('training_category_ref_id, module_name', 'required'),
			array('training_category_ref_id, parent_ref_id, course_duration, assessment_duration, is_active', 'numerical', 'integerOnly'=>true),
			array('module_name', 'length', 'max'=>100),
			array('added_by', 'length', 'max'=>10),
			array('module_description, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('training_module_id, training_category_ref_id, parent_ref_id, module_name, module_description, course_duration, assessment_duration, is_active, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'trainingCategoryRef' => array(self::BELONGS_TO, 'TrainingCategory', 'training_category_ref_id'),
			'trainingModuleSlides' => array(self::HAS_MANY, 'TrainingModuleSlide', 'training_module_ref_id'),
			'trainingUserAssessments' => array(self::HAS_MANY, 'TrainingUserAssessment', 'training_module_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'training_module_id' => 'Training Module',
			'training_category_ref_id' => 'Training Category Ref',
			'parent_ref_id' => 'Parent Ref',
			'module_name' => 'Module Name',
			'module_description' => 'Module Description',
			'course_duration' => 'Course Duration',
			'assessment_duration' => 'Assessment Duration',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('training_module_id',$this->training_module_id);
		$criteria->compare('training_category_ref_id',$this->training_category_ref_id);
		$criteria->compare('parent_ref_id',$this->parent_ref_id);
		$criteria->compare('module_name',$this->module_name,true);
		$criteria->compare('module_description',$this->module_description,true);
		$criteria->compare('course_duration',$this->course_duration);
		$criteria->compare('assessment_duration',$this->assessment_duration);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}