<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTrainingModuleSlideAssessmentAnswer is autogenerate by UniModel generator
 *
 * This is the model class for table "training_module_slide_assessment_answer".
 *
 * The followings are the available columns in table 'training_module_slide_assessment_answer':
 * @property string $training_module_slide_assessment_answer_id
 * @property string $training_module_slide_assessment_question_ref_id
 * @property string $answer
 * @property integer $display_order
 * @property string $is_answer
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TrainingModuleSlideAssessmentQuestion $trainingModuleSlideAssessmentQuestionRef
 * @property LoginMaster $addedBy
 * @property TrainingUserAssessment[] $trainingUserAssessments
 */
class BaseTrainingModuleSlideAssessmentAnswer extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TrainingModuleSlideAssessmentAnswer the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'training_module_slide_assessment_answer';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('training_module_slide_assessment_question_ref_id, answer', 'required'),
			array('display_order', 'numerical', 'integerOnly'=>true),
			array('training_module_slide_assessment_question_ref_id, added_by', 'length', 'max'=>10),
			array('is_answer', 'length', 'max'=>1),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('training_module_slide_assessment_answer_id, training_module_slide_assessment_question_ref_id, answer, display_order, is_answer, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'trainingModuleSlideAssessmentQuestionRef' => array(self::BELONGS_TO, 'TrainingModuleSlideAssessmentQuestion', 'training_module_slide_assessment_question_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'trainingUserAssessments' => array(self::HAS_MANY, 'TrainingUserAssessment', 'training_module_slide_assessment_answer_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'training_module_slide_assessment_answer_id' => 'Training Module Slide Assessment Answer',
			'training_module_slide_assessment_question_ref_id' => 'Training Module Slide Assessment Question Ref',
			'answer' => 'Answer',
			'display_order' => 'Display Order',
			'is_answer' => 'Is Answer',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('training_module_slide_assessment_answer_id',$this->training_module_slide_assessment_answer_id,true);
		$criteria->compare('training_module_slide_assessment_question_ref_id',$this->training_module_slide_assessment_question_ref_id,true);
		$criteria->compare('answer',$this->answer,true);
		$criteria->compare('display_order',$this->display_order);
		$criteria->compare('is_answer',$this->is_answer,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}