<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseTrainingModuleSlideAssessmentQuestion is autogenerate by UniModel generator
 *
 * This is the model class for table "training_module_slide_assessment_question".
 *
 * The followings are the available columns in table 'training_module_slide_assessment_question':
 * @property string $training_module_slide_assessment_question_id
 * @property string $training_module_slide_ref_id
 * @property string $question
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TrainingModuleSlideAssessmentAnswer[] $trainingModuleSlideAssessmentAnswers
 * @property LoginMaster $addedBy
 * @property TrainingModuleSlide $trainingModuleSlideRef
 * @property TrainingUserAssessment[] $trainingUserAssessments
 */
class BaseTrainingModuleSlideAssessmentQuestion extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return TrainingModuleSlideAssessmentQuestion the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'training_module_slide_assessment_question';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('training_module_slide_ref_id, question', 'required'),
			array('training_module_slide_ref_id, added_by', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('training_module_slide_assessment_question_id, training_module_slide_ref_id, question, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'trainingModuleSlideAssessmentAnswers' => array(self::HAS_MANY, 'TrainingModuleSlideAssessmentAnswer', 'training_module_slide_assessment_question_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'trainingModuleSlideRef' => array(self::BELONGS_TO, 'TrainingModuleSlide', 'training_module_slide_ref_id'),
			'trainingUserAssessments' => array(self::HAS_MANY, 'TrainingUserAssessment', 'training_module_slide_assessment_question_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'training_module_slide_assessment_question_id' => 'Training Module Slide Assessment Question',
			'training_module_slide_ref_id' => 'Training Module Slide Ref',
			'question' => 'Question',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('training_module_slide_assessment_question_id',$this->training_module_slide_assessment_question_id,true);
		$criteria->compare('training_module_slide_ref_id',$this->training_module_slide_ref_id,true);
		$criteria->compare('question',$this->question,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}