<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailAttachment is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_attachment".
 *
 * The followings are the available columns in table 'umail_attachment':
 * @property string $umail_attachment_id
 * @property integer $message_id
 * @property string $added_on
 * @property string $type
 * @property string $filename
 * @property string $original_file_name
 */
class BaseUmailAttachment extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailAttachment the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_attachment';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('message_id', 'required'),
			array('message_id', 'numerical', 'integerOnly'=>true),
			array('type', 'length', 'max'=>20),
			array('filename, original_file_name', 'length', 'max'=>255),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_attachment_id, message_id, added_on, type, filename, original_file_name', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_attachment_id' => 'Umail Attachment',
			'message_id' => 'Message',
			'added_on' => 'Added On',
			'type' => 'Type',
			'filename' => 'Filename',
			'original_file_name' => 'Original File Name',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_attachment_id',$this->umail_attachment_id,true);
		$criteria->compare('message_id',$this->message_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('type',$this->type,true);
		$criteria->compare('filename',$this->filename,true);
		$criteria->compare('original_file_name',$this->original_file_name,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}