<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailAttachmentLog is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_attachment_log".
 *
 * The followings are the available columns in table 'umail_attachment_log':
 * @property string $umail_attachment_log_id
 * @property string $umail_review_message_log_ref_id
 * @property string $filename
 * @property string $original_file_name
 * @property integer $added_by
 * @property string $added_on
 */
class BaseUmailAttachmentLog extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailAttachmentLog the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_attachment_log';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('umail_review_message_log_ref_id, filename, original_file_name, added_by, added_on', 'required'),
			array('added_by', 'numerical', 'integerOnly'=>true),
			array('umail_review_message_log_ref_id', 'length', 'max'=>10),
			array('filename, original_file_name', 'length', 'max'=>255),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('umail_attachment_log_id, umail_review_message_log_ref_id, filename, original_file_name, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'umail_attachment_log_id' => 'Umail Attachment Log',
			'umail_review_message_log_ref_id' => 'Umail Review Message Log Ref',
			'filename' => 'Filename',
			'original_file_name' => 'Original File Name',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('umail_attachment_log_id',$this->umail_attachment_log_id,true);
		$criteria->compare('umail_review_message_log_ref_id',$this->umail_review_message_log_ref_id,true);
		$criteria->compare('filename',$this->filename,true);
		$criteria->compare('original_file_name',$this->original_file_name,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}