<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUmailHeader is autogenerate by UniModel generator
 *
 * This is the model class for table "umail_header".
 *
 * The followings are the available columns in table 'umail_header':
 * @property integer $header_id
 * @property integer $sender_type
 * @property integer $sender_id
 * @property integer $recipient_type
 * @property integer $recipient_id
 * @property integer $querytype_id
 * @property integer $university_ref_id
 * @property string $added_on
 * @property string $last_replied_on
 * @property integer $original_advisor_id
 * @property integer $current_advisor_id
 * @property string $status
 * @property string $unique_id
 *
 * The followings are the available model relations:
 * @property QueryType $querytype
 * @property SenderRecipientType $recipientType
 * @property SenderRecipientType $senderType
 * @property UmailLog[] $umailLogs
 * @property UmailMessage[] $umailMessages
 */
class BaseUmailHeader extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UmailHeader the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'umail_header';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sender_type, sender_id, recipient_type, added_on, original_advisor_id, unique_id', 'required'),
			array('sender_type, sender_id, recipient_type, recipient_id, querytype_id, university_ref_id, original_advisor_id, current_advisor_id', 'numerical', 'integerOnly'=>true),
			array('status', 'length', 'max'=>9),
			array('unique_id', 'length', 'max'=>50),
			array('last_replied_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('header_id, sender_type, sender_id, recipient_type, recipient_id, querytype_id, university_ref_id, added_on, last_replied_on, original_advisor_id, current_advisor_id, status, unique_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'querytype' => array(self::BELONGS_TO, 'QueryType', 'querytype_id'),
			'recipientType' => array(self::BELONGS_TO, 'SenderRecipientType', 'recipient_type'),
			'senderType' => array(self::BELONGS_TO, 'SenderRecipientType', 'sender_type'),
			'umailLogs' => array(self::HAS_MANY, 'UmailLog', 'header_ref_id'),
			'umailMessages' => array(self::HAS_MANY, 'UmailMessage', 'header_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'header_id' => 'Header',
			'sender_type' => 'Sender Type',
			'sender_id' => 'Sender',
			'recipient_type' => 'Recipient Type',
			'recipient_id' => 'Recipient',
			'querytype_id' => 'Querytype',
			'university_ref_id' => 'University Ref',
			'added_on' => 'Added On',
			'last_replied_on' => 'Last Replied On',
			'original_advisor_id' => 'Original Advisor',
			'current_advisor_id' => 'Current Advisor',
			'status' => 'Status',
			'unique_id' => 'Unique',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('header_id',$this->header_id);
		$criteria->compare('sender_type',$this->sender_type);
		$criteria->compare('sender_id',$this->sender_id);
		$criteria->compare('recipient_type',$this->recipient_type);
		$criteria->compare('recipient_id',$this->recipient_id);
		$criteria->compare('querytype_id',$this->querytype_id);
		$criteria->compare('university_ref_id',$this->university_ref_id);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('last_replied_on',$this->last_replied_on,true);
		$criteria->compare('original_advisor_id',$this->original_advisor_id);
		$criteria->compare('current_advisor_id',$this->current_advisor_id);
		$criteria->compare('status',$this->status,true);
		$criteria->compare('unique_id',$this->unique_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}