<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniAnalytic is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_analytic".
 *
 * The followings are the available columns in table 'uni_analytic':
 * @property string $analytic_id
 * @property string $session_id
 * @property integer $user_ref_id
 * @property string $ip_address
 * @property string $curr_url
 * @property string $referer_url
 * @property string $referer_base_domain
 * @property string $remark
 * @property string $added_on
 */
class BaseUniAnalytic extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniAnalytic the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_analytic';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ip_address, curr_url, added_on', 'required'),
			array('user_ref_id', 'numerical', 'integerOnly'=>true),
			array('session_id', 'length', 'max'=>100),
			array('ip_address', 'length', 'max'=>20),
			array('referer_base_domain', 'length', 'max'=>70),
			array('remark', 'length', 'max'=>255),
			array('referer_url', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('analytic_id, session_id, user_ref_id, ip_address, curr_url, referer_url, referer_base_domain, remark, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'analytic_id' => 'Analytic',
			'session_id' => 'Session',
			'user_ref_id' => 'User Ref',
			'ip_address' => 'Ip Address',
			'curr_url' => 'Curr Url',
			'referer_url' => 'Referer Url',
			'referer_base_domain' => 'Referer Base Domain',
			'remark' => 'Remark',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('analytic_id',$this->analytic_id,true);
		$criteria->compare('session_id',$this->session_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id);
		$criteria->compare('ip_address',$this->ip_address,true);
		$criteria->compare('curr_url',$this->curr_url,true);
		$criteria->compare('referer_url',$this->referer_url,true);
		$criteria->compare('referer_base_domain',$this->referer_base_domain,true);
		$criteria->compare('remark',$this->remark,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}