<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniCourseContact is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_course_contact".
 *
 * The followings are the available columns in table 'uni_course_contact':
 * @property string $uni_course_contact_id
 * @property integer $uni_ref_id
 * @property string $uni_course_ref_id
 * @property string $contact_name
 * @property string $designation
 * @property string $email
 * @property string $contact_numbers
 * @property string $added_on
 * @property integer $added_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 */
class BaseUniCourseContact extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniCourseContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_course_contact';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, added_by', 'numerical', 'integerOnly'=>true),
			array('uni_course_ref_id', 'length', 'max'=>11),
			array('contact_name', 'length', 'max'=>255),
			array('designation', 'length', 'max'=>75),
			array('email, contact_numbers', 'length', 'max'=>100),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uni_course_contact_id, uni_ref_id, uni_course_ref_id, contact_name, designation, email, contact_numbers, added_on, added_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uni_course_contact_id' => 'Uni Course Contact',
			'uni_ref_id' => 'Uni Ref',
			'uni_course_ref_id' => 'Uni Course Ref',
			'contact_name' => 'Contact Name',
			'designation' => 'Designation',
			'email' => 'Email',
			'contact_numbers' => 'Contact Numbers',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('uni_course_contact_id',$this->uni_course_contact_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_course_ref_id',$this->uni_course_ref_id,true);
		$criteria->compare('contact_name',$this->contact_name,true);
		$criteria->compare('designation',$this->designation,true);
		$criteria->compare('email',$this->email,true);
		$criteria->compare('contact_numbers',$this->contact_numbers,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}