<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUnivarietyStudentVideoTrack is autogenerate by UniModel generator
 *
 * This is the model class for table "univariety_student_video_track".
 *
 * The followings are the available columns in table 'univariety_student_video_track':
 * @property string $univariety_student_video_track_id
 * @property integer $inst_ref_id
 * @property string $user_ref_id
 * @property string $visit
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 * @property TblSiDi $instRef
 */
class BaseUnivarietyStudentVideoTrack extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UnivarietyStudentVideoTrack the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'univariety_student_video_track';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('inst_ref_id', 'numerical', 'integerOnly'=>true),
			array('user_ref_id', 'length', 'max'=>10),
			array('visit', 'length', 'max'=>5),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('univariety_student_video_track_id, inst_ref_id, user_ref_id, visit, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'instRef' => array(self::BELONGS_TO, 'TblSiDi', 'inst_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'univariety_student_video_track_id' => 'Univariety Student Video Track',
			'inst_ref_id' => 'Inst Ref',
			'user_ref_id' => 'User Ref',
			'visit' => 'Visit',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('univariety_student_video_track_id',$this->univariety_student_video_track_id,true);
		$criteria->compare('inst_ref_id',$this->inst_ref_id);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('visit',$this->visit,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}