<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniveristyContact is autogenerate by UniModel generator
 *
 * This is the model class for table "univeristy_contact".
 *
 * The followings are the available columns in table 'univeristy_contact':
 * @property string $univeristy_contact_id
 * @property integer $uni_ref_id
 * @property string $country_code
 * @property string $state_code
 * @property string $contact_number
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 * @property TblAdmin $addedBy
 * @property TblAdmin $modifiedBy
 */
class BaseUniveristyContact extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniveristyContact the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'univeristy_contact';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, contact_number', 'required'),
			array('uni_ref_id, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('country_code, state_code', 'length', 'max'=>10),
			array('contact_number', 'length', 'max'=>15),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('univeristy_contact_id, uni_ref_id, country_code, state_code, contact_number, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'univeristy_contact_id' => 'Univeristy Contact',
			'uni_ref_id' => 'Uni Ref',
			'country_code' => 'Country Code',
			'state_code' => 'State Code',
			'contact_number' => 'Contact Number',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('univeristy_contact_id',$this->univeristy_contact_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('country_code',$this->country_code,true);
		$criteria->compare('state_code',$this->state_code,true);
		$criteria->compare('contact_number',$this->contact_number,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}