<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityAdmissionDates is autogenerate by UniModel generator
 *
 * This is the model class for table "university_admission_dates".
 *
 * The followings are the available columns in table 'university_admission_dates':
 * @property string $university_admission_dates_id
 * @property integer $uni_ref_id
 * @property string $intake_name
 * @property integer $course_level_ref_id
 * @property integer $no_of_intakes
 * @property integer $early_application_open_day
 * @property integer $early_application_open_month
 * @property integer $regular_application_open_day
 * @property integer $regular_application_open_month
 * @property integer $early_application_close_day
 * @property integer $early_application_close_month
 * @property integer $regular_application_close_day
 * @property integer $regular_application_close_month
 * @property integer $early_decision_day
 * @property integer $early_decision_month
 * @property integer $regular_decision_day
 * @property integer $regular_decision_month
 * @property integer $early_acceptance_day
 * @property integer $early_acceptance_month
 * @property integer $regular_acceptance_day
 * @property integer $regular_acceptance_month
 * @property integer $early_class_start_day
 * @property integer $early_class_start_month
 * @property integer $regular_class_start_day
 * @property integer $regular_class_start_month
 * @property integer $added_by
 * @property string $added_on
 * @property integer $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property TblAdmin $addedBy
 * @property LookupCourseLevel $courseLevelRef
 * @property TblAdmin $modifiedBy
 * @property TblUniversityMaster $uniRef
 */
class BaseUniversityAdmissionDates extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityAdmissionDates the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_admission_dates';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, course_level_ref_id', 'required'),
			array('uni_ref_id, course_level_ref_id, no_of_intakes, early_application_open_day, early_application_open_month, regular_application_open_day, regular_application_open_month, early_application_close_day, early_application_close_month, regular_application_close_day, regular_application_close_month, early_decision_day, early_decision_month, regular_decision_day, regular_decision_month, early_acceptance_day, early_acceptance_month, regular_acceptance_day, regular_acceptance_month, early_class_start_day, early_class_start_month, regular_class_start_day, regular_class_start_month, added_by, modified_by', 'numerical', 'integerOnly'=>true),
			array('intake_name', 'length', 'max'=>6),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_admission_dates_id, uni_ref_id, intake_name, course_level_ref_id, no_of_intakes, early_application_open_day, early_application_open_month, regular_application_open_day, regular_application_open_month, early_application_close_day, early_application_close_month, regular_application_close_day, regular_application_close_month, early_decision_day, early_decision_month, regular_decision_day, regular_decision_month, early_acceptance_day, early_acceptance_month, regular_acceptance_day, regular_acceptance_month, early_class_start_day, early_class_start_month, regular_class_start_day, regular_class_start_month, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'TblAdmin', 'added_by'),
			'courseLevelRef' => array(self::BELONGS_TO, 'LookupCourseLevel', 'course_level_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_admission_dates_id' => 'University Admission Dates',
			'uni_ref_id' => 'Uni Ref',
			'intake_name' => 'Intake Name',
			'course_level_ref_id' => 'Course Level Ref',
			'no_of_intakes' => 'No Of Intakes',
			'early_application_open_day' => 'Early Application Open Day',
			'early_application_open_month' => 'Early Application Open Month',
			'regular_application_open_day' => 'Regular Application Open Day',
			'regular_application_open_month' => 'Regular Application Open Month',
			'early_application_close_day' => 'Early Application Close Day',
			'early_application_close_month' => 'Early Application Close Month',
			'regular_application_close_day' => 'Regular Application Close Day',
			'regular_application_close_month' => 'Regular Application Close Month',
			'early_decision_day' => 'Early Decision Day',
			'early_decision_month' => 'Early Decision Month',
			'regular_decision_day' => 'Regular Decision Day',
			'regular_decision_month' => 'Regular Decision Month',
			'early_acceptance_day' => 'Early Acceptance Day',
			'early_acceptance_month' => 'Early Acceptance Month',
			'regular_acceptance_day' => 'Regular Acceptance Day',
			'regular_acceptance_month' => 'Regular Acceptance Month',
			'early_class_start_day' => 'Early Class Start Day',
			'early_class_start_month' => 'Early Class Start Month',
			'regular_class_start_day' => 'Regular Class Start Day',
			'regular_class_start_month' => 'Regular Class Start Month',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_admission_dates_id',$this->university_admission_dates_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('intake_name',$this->intake_name,true);
		$criteria->compare('course_level_ref_id',$this->course_level_ref_id);
		$criteria->compare('no_of_intakes',$this->no_of_intakes);
		$criteria->compare('early_application_open_day',$this->early_application_open_day);
		$criteria->compare('early_application_open_month',$this->early_application_open_month);
		$criteria->compare('regular_application_open_day',$this->regular_application_open_day);
		$criteria->compare('regular_application_open_month',$this->regular_application_open_month);
		$criteria->compare('early_application_close_day',$this->early_application_close_day);
		$criteria->compare('early_application_close_month',$this->early_application_close_month);
		$criteria->compare('regular_application_close_day',$this->regular_application_close_day);
		$criteria->compare('regular_application_close_month',$this->regular_application_close_month);
		$criteria->compare('early_decision_day',$this->early_decision_day);
		$criteria->compare('early_decision_month',$this->early_decision_month);
		$criteria->compare('regular_decision_day',$this->regular_decision_day);
		$criteria->compare('regular_decision_month',$this->regular_decision_month);
		$criteria->compare('early_acceptance_day',$this->early_acceptance_day);
		$criteria->compare('early_acceptance_month',$this->early_acceptance_month);
		$criteria->compare('regular_acceptance_day',$this->regular_acceptance_day);
		$criteria->compare('regular_acceptance_month',$this->regular_acceptance_month);
		$criteria->compare('early_class_start_day',$this->early_class_start_day);
		$criteria->compare('early_class_start_month',$this->early_class_start_month);
		$criteria->compare('regular_class_start_day',$this->regular_class_start_day);
		$criteria->compare('regular_class_start_month',$this->regular_class_start_month);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}