<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityAlumni is autogenerate by UniModel generator
 *
 * This is the model class for table "university_alumni".
 *
 * The followings are the available columns in table 'university_alumni':
 * @property integer $university_alumni_id
 * @property integer $uni_ref_id
 * @property string $alumni_text
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseUniversityAlumni extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityAlumni the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_alumni';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, alumni_text, added_on', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_alumni_id, uni_ref_id, alumni_text, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_alumni_id' => 'University Alumni',
			'uni_ref_id' => 'Uni Ref',
			'alumni_text' => 'Alumni Text',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_alumni_id',$this->university_alumni_id);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('alumni_text',$this->alumni_text,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}