<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityCourseDateDescription is autogenerate by UniModel generator
 *
 * This is the model class for table "university_course_date_description".
 *
 * The followings are the available columns in table 'university_course_date_description':
 * @property string $course_date_description_id
 * @property string $course_ref_id
 * @property string $date_description
 * @property integer $date_day
 * @property integer $date_month
 * @property integer $date_year
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property TblUniCourses $courseRef
 * @property LoginMaster $modifiedBy
 */
class BaseUniversityCourseDateDescription extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityCourseDateDescription the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_course_date_description';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('course_ref_id, date_description, added_on', 'required'),
			array('date_day, date_month, date_year', 'numerical', 'integerOnly'=>true),
			array('course_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('date_description', 'length', 'max'=>255),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('course_date_description_id, course_ref_id, date_description, date_day, date_month, date_year, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'courseRef' => array(self::BELONGS_TO, 'TblUniCourses', 'course_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'course_date_description_id' => 'Course Date Description',
			'course_ref_id' => 'Course Ref',
			'date_description' => 'Date Description',
			'date_day' => 'Date Day',
			'date_month' => 'Date Month',
			'date_year' => 'Date Year',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('course_date_description_id',$this->course_date_description_id,true);
		$criteria->compare('course_ref_id',$this->course_ref_id,true);
		$criteria->compare('date_description',$this->date_description,true);
		$criteria->compare('date_day',$this->date_day);
		$criteria->compare('date_month',$this->date_month);
		$criteria->compare('date_year',$this->date_year);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}