<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityDateIntake is autogenerate by UniModel generator
 *
 * This is the model class for table "university_date_intake".
 *
 * The followings are the available columns in table 'university_date_intake':
 * @property string $university_date_intake_id
 * @property integer $uni_ref_id
 * @property integer $course_level_ref_id
 * @property integer $no_of_intake
 * @property string $copy_aff_uni_dates
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property DeleteCopyUniversityDateSection[] $deleteCopyUniversityDateSections
 * @property LoginMaster $addedBy
 * @property LookupCourseLevel $courseLevelRef
 * @property LoginMaster $modifiedBy
 * @property TblUniversityMaster $uniRef
 * @property UniversityDateSection[] $universityDateSections
 * @property UniversityDateIntakeDescription[] $universityDateIntakeDescriptions
 */
class BaseUniversityDateIntake extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityDateIntake the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_date_intake';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, course_level_ref_id, no_of_intake, added_on', 'required'),
			array('uni_ref_id, course_level_ref_id, no_of_intake', 'numerical', 'integerOnly'=>true),
			array('copy_aff_uni_dates', 'length', 'max'=>1),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_date_intake_id, uni_ref_id, course_level_ref_id, no_of_intake, copy_aff_uni_dates, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'deleteCopyUniversityDateSections' => array(self::HAS_MANY, 'DeleteCopyUniversityDateSection', 'university_date_intake_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'courseLevelRef' => array(self::BELONGS_TO, 'LookupCourseLevel', 'course_level_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
            'universityDateSections' => array(self::HAS_MANY, 'UniversityDateSection', 'university_date_intake_ref_id'),
			'universityDateIntakeDescriptions' => array(self::HAS_MANY, 'UniversityDateIntakeDescription', 'university_date_intake_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_date_intake_id' => 'University Date Intake',
			'uni_ref_id' => 'Uni Ref',
			'course_level_ref_id' => 'Course Level Ref',
			'no_of_intake' => 'No Of Intake',
			'copy_aff_uni_dates' => 'Copy Aff Uni Dates',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_date_intake_id',$this->university_date_intake_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('course_level_ref_id',$this->course_level_ref_id);
		$criteria->compare('no_of_intake',$this->no_of_intake);
		$criteria->compare('copy_aff_uni_dates',$this->copy_aff_uni_dates,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}