<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniversityShortName is autogenerate by UniModel generator
 *
 * This is the model class for table "university_short_name".
 *
 * The followings are the available columns in table 'university_short_name':
 * @property string $university_short_name_id
 * @property integer $uni_ref_id
 * @property string $uni_short_name
 * @property string $is_primary
 * @property string $added_by
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUniversityMaster $uniRef
 * @property LoginMaster $addedBy
 */
class BaseUniversityShortName extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniversityShortName the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'university_short_name';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('uni_short_name', 'length', 'max'=>150),
			array('is_primary', 'length', 'max'=>1),
			array('added_by', 'length', 'max'=>10),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('university_short_name_id, uni_ref_id, uni_short_name, is_primary, added_by, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'university_short_name_id' => 'University Short Name',
			'uni_ref_id' => 'Uni Ref',
			'uni_short_name' => 'Uni Short Name',
			'is_primary' => 'Is Primary',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('university_short_name_id',$this->university_short_name_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('uni_short_name',$this->uni_short_name,true);
		$criteria->compare('is_primary',$this->is_primary,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}