<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserIdealList is autogenerate by UniModel generator
 *
 * This is the model class for table "user_ideal_list".
 *
 * The followings are the available columns in table 'user_ideal_list':
 * @property string $user_ideal_list_id
 * @property string $user_ref_id
 * @property integer $department_ref_id
 * @property integer $country_ref_id
 * @property integer $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property LookupDepartment $departmentRef
 * @property TblUserMaster $userRef
 * @property TblCountryMaster $countryRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property UserIdealListUniversity[] $userIdealListUniversities
 * @property UserIdealListUniversityLog[] $userIdealListUniversityLogs
 */
class BaseUserIdealList extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserIdealList the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_ideal_list';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, department_ref_id, country_ref_id, is_active, added_on, added_by', 'required'),
			array('department_ref_id, country_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('user_ref_id, added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_ideal_list_id, user_ref_id, department_ref_id, country_ref_id, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'departmentRef' => array(self::BELONGS_TO, 'LookupDepartment', 'department_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'userIdealListUniversities' => array(self::HAS_MANY, 'UserIdealListUniversity', 'user_ideal_list_ref_id'),
			'userIdealListUniversityLogs' => array(self::HAS_MANY, 'UserIdealListUniversityLog', 'user_ideal_list_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_ideal_list_id' => 'User Ideal List',
			'user_ref_id' => 'User Ref',
			'department_ref_id' => 'Department Ref',
			'country_ref_id' => 'Country Ref',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_ideal_list_id',$this->user_ideal_list_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('department_ref_id',$this->department_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}