<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserOutplacementMessage is autogenerate by UniModel generator
 *
 * This is the model class for table "user_outplacement_message".
 *
 * The followings are the available columns in table 'user_outplacement_message':
 * @property string $user_outplacement_message_id
 * @property string $user_ref_id
 * @property string $message
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseUserOutplacementMessage extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserOutplacementMessage the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_outplacement_message';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('user_ref_id, added_on', 'required'),
			array('user_ref_id', 'length', 'max'=>10),
			array('message', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_outplacement_message_id, user_ref_id, message, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_outplacement_message_id' => 'User Outplacement Message',
			'user_ref_id' => 'User Ref',
			'message' => 'Message',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_outplacement_message_id',$this->user_outplacement_message_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('message',$this->message,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}