<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserSearch is autogenerate by UniModel generator
 *
 * This is the model class for table "user_search".
 *
 * The followings are the available columns in table 'user_search':
 * @property integer $user_search_id
 * @property string $ip_address
 * @property string $user_ref_id
 * @property string $keyword
 * @property string $category
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property TblUserMaster $userRef
 */
class BaseUserSearch extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserSearch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_search';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('ip_address', 'required'),
			array('ip_address', 'length', 'max'=>20),
			array('user_ref_id', 'length', 'max'=>10),
			array('keyword', 'length', 'max'=>255),
			array('category', 'length', 'max'=>11),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_search_id, ip_address, user_ref_id, keyword, category, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_search_id' => 'User Search',
			'ip_address' => 'Ip Address',
			'user_ref_id' => 'User Ref',
			'keyword' => 'Keyword',
			'category' => 'Category',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_search_id',$this->user_search_id);
		$criteria->compare('ip_address',$this->ip_address,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('keyword',$this->keyword,true);
		$criteria->compare('category',$this->category,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}