<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUserUniversitySearch is autogenerate by UniModel generator
 *
 * This is the model class for table "user_university_search".
 *
 * The followings are the available columns in table 'user_university_search':
 * @property string $user_university_search_id
 * @property string $login_ref_id
 * @property string $search_text
 *
 * The followings are the available model relations:
 * @property LoginMaster $loginRef
 */
class BaseUserUniversitySearch extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UserUniversitySearch the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'user_university_search';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('login_ref_id, search_text', 'required'),
			array('login_ref_id', 'length', 'max'=>10),
			array('search_text', 'length', 'max'=> 2000),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('user_university_search_id, login_ref_id, search_text', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'user_university_search_id' => 'User University Search',
			'login_ref_id' => 'Login Ref',
			'search_text' => 'Search Text',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('user_university_search_id',$this->user_university_search_id,true);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('search_text',$this->search_text,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}