<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentre is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre".
 *
 * The followings are the available columns in table 'vendor_centre':
 * @property string $vendor_centre_id
 * @property integer $vendor_ref_id
 * @property string $centre_name
 * @property string $centre_logo
 * @property string $website
 * @property integer $establishment_year
 * @property string $description
 * @property string $center_image
 * @property string $address1
 * @property string $address2
 * @property string $zip_code
 * @property integer $city_ref_id
 * @property integer $state_ref_id
 * @property integer $country_ref_id
 * @property integer $locality_ref_id
 * @property string $longitude
 * @property string $latitude
 * @property string $is_validated
 * @property string $is_registered
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property Vendor $vendorRef
 * @property TblCityMaster $cityRef
 * @property TblState $stateRef
 * @property TblCountryMaster $countryRef
 * @property LookupLocality $localityRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property VendorCentreCourse[] $vendorCentreCourses
 * @property VendorCentreFaculty[] $vendorCentreFaculties
 * @property VendorCentreGallery[] $vendorCentreGalleries
 * @property VendorCentreSuccessfulStudents[] $vendorCentreSuccessfulStudents
 * @property VendorCentreTimings[] $vendorCentreTimings
 */
class BaseVendorCentre extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentre the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('vendor_ref_id, establishment_year, city_ref_id, state_ref_id, country_ref_id, locality_ref_id, is_active', 'numerical', 'integerOnly'=>true),
			array('centre_name, centre_logo, website, address1, address2, longitude, latitude', 'length', 'max'=>255),
			array('zip_code, added_by, modified_by', 'length', 'max'=>10),
			array('is_validated, is_registered', 'length', 'max'=>1),
			array('description, center_image, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('centre_name,website, establishment_year, address1, address2, zip_code, city_ref_id, state_ref_id, country_ref_id, locality_ref_id, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
			'cityRef' => array(self::BELONGS_TO, 'TblCityMaster', 'city_ref_id'),
			'stateRef' => array(self::BELONGS_TO, 'TblState', 'state_ref_id'),
			'countryRef' => array(self::BELONGS_TO, 'TblCountryMaster', 'country_ref_id'),
			'localityRef' => array(self::BELONGS_TO, 'LookupLocality', 'locality_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorCentreCourses' => array(self::HAS_MANY, 'VendorCentreCourse', 'vendor_centre_ref_id'),
			'vendorCentreFaculties' => array(self::HAS_MANY, 'VendorCentreFaculty', 'vendor_centre_ref_id'),
			'vendorCentreGalleries' => array(self::HAS_MANY, 'VendorCentreGallery', 'vendor_centre_ref_id'),
			'vendorCentreSuccessfulStudents' => array(self::HAS_MANY, 'VendorCentreSuccessfulStudents', 'vendor_centre_ref_id'),
			'vendorCentreTimings' => array(self::HAS_MANY, 'VendorCentreTimings', 'vendor_centre_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_id' => 'Vendor Centre',
			'vendor_ref_id' => 'Vendor Ref',
			'centre_name' => 'Centre Name',
			'centre_logo' => 'Centre Logo',
			'website' => 'Website',
			'establishment_year' => 'Establishment Year',
			'description' => 'Description',
			'center_image' => 'Center Image',
			'address1' => 'Address1',
			'address2' => 'Address2',
			'zip_code' => 'Zip Code',
			'city_ref_id' => 'City Ref',
			'state_ref_id' => 'State Ref',
			'country_ref_id' => 'Country Ref',
			'locality_ref_id' => 'Locality Ref',
			'longitude' => 'Longitude',
			'latitude' => 'Latitude',
			'is_validated' => 'Is Validated',
			'is_registered' => 'Is Registered',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('centre_name',$this->centre_name,true);
		$criteria->compare('establishment_year',$this->establishment_year);
		$criteria->compare('address1',$this->address1,true);
		$criteria->compare('address2',$this->address2,true);
		$criteria->compare('zip_code',$this->zip_code,true);
		$criteria->compare('city_ref_id',$this->city_ref_id);
		$criteria->compare('state_ref_id',$this->state_ref_id);
		$criteria->compare('country_ref_id',$this->country_ref_id);
		$criteria->compare('locality_ref_id',$this->locality_ref_id);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}