<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreContactNumber is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_contact_number".
 *
 * The followings are the available columns in table 'vendor_centre_contact_number':
 * @property string $vendor_centre_contact_number_id
 * @property integer $vendor_centre_contact_ref_id
 * @property string $contact_type
 * @property string $country_code
 * @property string $number
 *
 * The followings are the available model relations:
 * @property VendorCentreContact $vendorCentreContactRef
 */
class BaseVendorCentreContactNumber extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreContactNumber the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_contact_number';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_centre_contact_ref_id, contact_type, number', 'required'),
			array('vendor_centre_contact_ref_id', 'numerical', 'integerOnly'=>true),
			array('contact_type', 'length', 'max'=>8),
			array('country_code', 'length', 'max'=>10),
			array('number', 'length', 'max'=>20),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_contact_number_id, vendor_centre_contact_ref_id, contact_type, country_code, number', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreContactRef' => array(self::BELONGS_TO, 'VendorCentreContact', 'vendor_centre_contact_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_contact_number_id' => 'Vendor Centre Contact Number',
			'vendor_centre_contact_ref_id' => 'Vendor Centre Contact Ref',
			'contact_type' => 'Contact Type',
			'country_code' => 'Country Code',
			'number' => 'Number',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_contact_number_id',$this->vendor_centre_contact_number_id,true);
		$criteria->compare('vendor_centre_contact_ref_id',$this->vendor_centre_contact_ref_id);
		$criteria->compare('contact_type',$this->contact_type,true);
		$criteria->compare('country_code',$this->country_code,true);
		$criteria->compare('number',$this->number,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}