<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreCourse is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_course".
 *
 * The followings are the available columns in table 'vendor_centre_course':
 * @property string $vendor_centre_course_id
 * @property string $vendor_centre_ref_id
 * @property string $course_name
 * @property integer $duration_count
 * @property string $duration_type
 * @property integer $duration_hours
 * @property string $course_fee
 * @property integer $currency_ref_id
 * @property string $course_description
 * @property string $course_medium
 * @property string $course_image
 * @property string $is_validated
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property VendorCentreBatches[] $vendorCentreBatches
 * @property LoginMaster $addedBy
 * @property LookupCurrency $currencyRef
 * @property LoginMaster $modifiedBy
 * @property VendorCentre $vendorCentreRef
 * @property VendorCentreCourseAttachment[] $vendorCentreCourseAttachments
 * @property VendorCentreCourseCountry[] $vendorCentreCourseCountries
 * @property VendorCentreCourseDepartment[] $vendorCentreCourseDepartments
 * @property VendorCentreCourseGrade[] $vendorCentreCourseGrades
 * @property VendorCentreCourseTest[] $vendorCentreCourseTests
 * @property VendorCentreFacultyCourses[] $vendorCentreFacultyCourses
 */
class BaseVendorCentreCourse extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreCourse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_course';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('added_on', 'required'),
			array('duration_count, duration_hours, currency_ref_id', 'numerical', 'integerOnly'=>true),
			array('vendor_centre_ref_id, course_fee, added_by, modified_by', 'length', 'max'=>10),
			array('course_name, course_description', 'length', 'max'=>255),
			array('duration_type', 'length', 'max'=>5),
			array('course_medium', 'length', 'max'=>16),
			array('is_validated', 'length', 'max'=>1),
			array('course_image, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_course_id, vendor_centre_ref_id, course_name, duration_count, duration_type, duration_hours, course_fee, currency_ref_id, course_description, course_medium, course_image, is_validated, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreBatches' => array(self::HAS_MANY, 'VendorCentreBatches', 'vendor_centre_course_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'currencyRef' => array(self::BELONGS_TO, 'LookupCurrency', 'currency_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
			'vendorCentreCourseAttachments' => array(self::HAS_MANY, 'VendorCentreCourseAttachment', 'vendor_centre_course_ref_id'),
			'vendorCentreCourseCountries' => array(self::HAS_MANY, 'VendorCentreCourseCountry', 'vendor_centre_course_ref_id'),
			'vendorCentreCourseDepartments' => array(self::HAS_MANY, 'VendorCentreCourseDepartment', 'vendor_centre_course_ref_id'),
			'vendorCentreCourseGrades' => array(self::HAS_MANY, 'VendorCentreCourseGrade', 'vendor_centre_course_ref_id'),
			'vendorCentreCourseTests' => array(self::HAS_MANY, 'VendorCentreCourseTest', 'vendor_centre_course_ref_id'),
			'vendorCentreFacultyCourses' => array(self::HAS_MANY, 'VendorCentreFacultyCourses', 'vendor_centre_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_course_id' => 'Vendor Centre Course',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'course_name' => 'Course Name',
			'duration_count' => 'Duration Count',
			'duration_type' => 'Duration Type',
			'duration_hours' => 'Duration Hours',
			'course_fee' => 'Course Fee',
			'currency_ref_id' => 'Currency Ref',
			'course_description' => 'Course Description',
			'course_medium' => 'Course Medium',
			'course_image' => 'Course Image',
			'is_validated' => 'Is Validated',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_course_id',$this->vendor_centre_course_id,true);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('duration_count',$this->duration_count);
		$criteria->compare('duration_type',$this->duration_type,true);
		$criteria->compare('duration_hours',$this->duration_hours);
		$criteria->compare('course_fee',$this->course_fee,true);
		$criteria->compare('currency_ref_id',$this->currency_ref_id);
		$criteria->compare('course_description',$this->course_description,true);
		$criteria->compare('course_medium',$this->course_medium,true);
		$criteria->compare('course_image',$this->course_image,true);
		$criteria->compare('is_validated',$this->is_validated,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}