<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCentreStudentDiscount is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_centre_student_discount".
 *
 * The followings are the available columns in table 'vendor_centre_student_discount':
 * @property string $vendor_centre_student_discount_id
 * @property string $vendor_centre_ref_id
 * @property string $user_ref_id
 * @property string $course_name
 * @property string $registration_number
 * @property string $registration_date
 * @property integer $discount_percentage
 * @property string $fee_paid
 * @property string $added_on
 *
 * The followings are the available model relations:
 * @property VendorCentre $vendorCentreRef
 * @property TblUserMaster $userRef
 */
class BaseVendorCentreStudentDiscount extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCentreStudentDiscount the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_centre_student_discount';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('discount_percentage', 'numerical', 'integerOnly'=>true),
			array('vendor_centre_ref_id, user_ref_id, fee_paid', 'length', 'max'=>10),
			array('course_name', 'length', 'max'=>255),
			array('registration_number', 'length', 'max'=>100),
			array('registration_date, added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_centre_student_discount_id, vendor_centre_ref_id, user_ref_id, course_name, registration_number, registration_date, discount_percentage, fee_paid, added_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCentreRef' => array(self::BELONGS_TO, 'VendorCentre', 'vendor_centre_ref_id'),
			'userRef' => array(self::BELONGS_TO, 'TblUserMaster', 'user_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_centre_student_discount_id' => 'Vendor Centre Student Discount',
			'vendor_centre_ref_id' => 'Vendor Centre Ref',
			'user_ref_id' => 'User Ref',
			'course_name' => 'Course Name',
			'registration_number' => 'Registration Number',
			'registration_date' => 'Registration Date',
			'discount_percentage' => 'Discount Percentage',
			'fee_paid' => 'Fee Paid',
			'added_on' => 'Added On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_centre_student_discount_id',$this->vendor_centre_student_discount_id,true);
		$criteria->compare('vendor_centre_ref_id',$this->vendor_centre_ref_id,true);
		$criteria->compare('user_ref_id',$this->user_ref_id,true);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('registration_number',$this->registration_number,true);
		$criteria->compare('registration_date',$this->registration_date,true);
		$criteria->compare('discount_percentage',$this->discount_percentage);
		$criteria->compare('fee_paid',$this->fee_paid,true);
		$criteria->compare('added_on',$this->added_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}