<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseVendorCourse is autogenerate by UniModel generator
 *
 * This is the model class for table "vendor_course".
 *
 * The followings are the available columns in table 'vendor_course':
 * @property integer $vendor_course_id
 * @property integer $vendor_ref_id
 * @property string $course_name
 * @property string $duration_type
 * @property integer $duration
 * @property double $duration_in_months
 * @property string $course_description
 * @property string $additional_information
 * @property integer $is_active
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property VendorCenterVendorCourse[] $vendorCenterVendorCourses
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property Vendor $vendorRef
 * @property VendorCourseEntranceExam[] $vendorCourseEntranceExams
 */
class BaseVendorCourse extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return VendorCourse the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'vendor_course';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('vendor_ref_id, course_name, added_by, added_on', 'required'),
			array('vendor_ref_id, duration, is_active', 'numerical', 'integerOnly'=>true),
			array('duration_in_months', 'numerical'),
			array('course_name', 'length', 'max'=>255),
			array('duration_type', 'length', 'max'=>6),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('course_description, additional_information, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('vendor_course_id, vendor_ref_id, course_name, duration_type, duration, duration_in_months, course_description, additional_information, is_active, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'vendorCenterVendorCourses' => array(self::HAS_MANY, 'VendorCenterVendorCourse', 'vendor_course_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'vendorRef' => array(self::BELONGS_TO, 'Vendor', 'vendor_ref_id'),
			'vendorCourseEntranceExams' => array(self::HAS_MANY, 'VendorCourseEntranceExam', 'vendor_course_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'vendor_course_id' => 'Vendor Course',
			'vendor_ref_id' => 'Vendor Ref',
			'course_name' => 'Course Name',
			'duration_type' => 'Duration Type',
			'duration' => 'Duration',
			'duration_in_months' => 'Duration In Months',
			'course_description' => 'Course Description',
			'additional_information' => 'Additional Information',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('vendor_course_id',$this->vendor_course_id);
		$criteria->compare('vendor_ref_id',$this->vendor_ref_id);
		$criteria->compare('course_name',$this->course_name,true);
		$criteria->compare('duration_type',$this->duration_type,true);
		$criteria->compare('duration',$this->duration);
		$criteria->compare('duration_in_months',$this->duration_in_months);
		$criteria->compare('course_description',$this->course_description,true);
		$criteria->compare('additional_information',$this->additional_information,true);
		$criteria->compare('is_active',$this->is_active);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}