<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWebinarEventStudents is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_event_students".
 *
 * The followings are the available columns in table 'tbl_event_students':
 * @property integer $tbl_event_students_id
 * @property string $login_ref_id
 * @property integer $event_ref_id
 * @property string $join_url
 *
 * The followings are the available model relations:
 * @property TblEvent $eventRef
 * @property LoginMaster $loginRef
 */
class BaseWebinarEventStudents extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebinarEventStudents the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_event_students';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id', 'numerical', 'integerOnly'=>true),
			array('login_ref_id', 'length', 'max'=>10),
			array('join_url', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_event_students_id, login_ref_id, event_ref_id, join_url', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventRef' => array(self::BELONGS_TO, 'TblEvent', 'event_ref_id'),
			'loginRef' => array(self::BELONGS_TO, 'LoginMaster', 'login_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_event_students_id' => 'Tbl Event Students',
			'login_ref_id' => 'Login Ref',
			'event_ref_id' => 'Event Ref',
			'join_url' => 'Join Url',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_event_students_id',$this->tbl_event_students_id);
		$criteria->compare('login_ref_id',$this->login_ref_id,true);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('join_url',$this->join_url,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}