<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWebinarEventVideos is autogenerate by UniModel generator
 *
 * This is the model class for table "tbl_event_videos".
 *
 * The followings are the available columns in table 'tbl_event_videos':
 * @property string $tbl_event_videos_id
 * @property integer $event_ref_id
 * @property string $title
 * @property string $video_link
 * @property string $is_promoted
 * @property string $is_active
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_on
 * @property string $modified_by
 *
 * The followings are the available model relations:
 * @property TblEvent $eventRef
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 */
class BaseWebinarEventVideos extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WebinarEventVideos the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'tbl_event_videos';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('event_ref_id', 'numerical', 'integerOnly'=>true),
			array('title, video_link', 'length', 'max'=>250),
			array('is_promoted, is_active', 'length', 'max'=>1),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('tbl_event_videos_id, event_ref_id, title, video_link, is_promoted, is_active, added_on, added_by, modified_on, modified_by', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'webinarEvent' => array(self::BELONGS_TO, 'WebinarEvent', 'event_ref_id'),
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

        
	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'tbl_event_videos_id' => 'Tbl Event Videos',
			'event_ref_id' => 'Event Ref',
			'title' => 'Title',
			'video_link' => 'Video Link',
			'is_promoted' => 'Is Promoted',
			'is_active' => 'Is Active',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('tbl_event_videos_id',$this->tbl_event_videos_id,true);
		$criteria->compare('event_ref_id',$this->event_ref_id);
		$criteria->compare('title',$this->title,true);
		$criteria->compare('video_link',$this->video_link,true);
		$criteria->compare('is_promoted',$this->is_promoted,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}