<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWorkshopSi is autogenerate by UniModel generator
 *
 * This is the model class for table "workshop_si".
 *
 * The followings are the available columns in table 'workshop_si':
 * @property string $workshop_si_id
 * @property integer $workshop_master_ref_id
 * @property integer $si_ref_id
 * @property integer $board_ref_id
 * @property string $class
 * @property string $workshop_si_name
 * @property string $workshop_date
 * @property string $added_on
 * @property integer $added_by
 * @property integer $is_active
 *
 * The followings are the available model relations:
 * @property EventSi[] $eventSis
 * @property LookupBoard $boardRef
 * @property TblSiDi $siRef
 * @property WorkshopMaster $workshopMasterRef
 * @property WorkshopSiGroup[] $workshopSiGroups
 */
class BaseWorkshopSi extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkshopSi the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workshop_si';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('si_ref_id', 'workshop_date', 'workshop_si_name','required'),
			array('workshop_master_ref_id','required'),
			array('workshop_master_ref_id, si_ref_id, board_ref_id, added_by, is_active', 'numerical', 'integerOnly'=>true),
			array('class', 'length', 'max'=>2),
			array('workshop_si_name', 'length', 'max'=>150),
			array('added_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workshop_si_id, workshop_master_ref_id, si_ref_id, board_ref_id, class, workshop_si_name, workshop_date, added_on, added_by, is_active', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'eventSis' => array(self::HAS_MANY, 'EventSi', 'workshop_si_ref_Id'),
			'boardRef' => array(self::BELONGS_TO, 'LookupBoard', 'board_ref_id'),
			'siRef' => array(self::BELONGS_TO, 'TblSiDi', 'si_ref_id'),
			'workshopMasterRef' => array(self::BELONGS_TO, 'WorkshopMaster', 'workshop_master_ref_id'),
			'workshopSiGroups' => array(self::HAS_MANY, 'WorkshopSiGroup', 'workshop_si_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workshop_si_id' => 'Workshop Si',
			'workshop_master_ref_id' => 'Workshop Master Ref',
			'si_ref_id' => 'Si Ref',
			'board_ref_id' => 'Board Ref',
			'class' => 'Class',
			'workshop_si_name' => 'Workshop Si Name',
			'workshop_date' => 'Workshop Date',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'is_active' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workshop_si_id',$this->workshop_si_id,true);
		$criteria->compare('workshop_master_ref_id',$this->workshop_master_ref_id);
		$criteria->compare('si_ref_id',$this->si_ref_id);
		$criteria->compare('board_ref_id',$this->board_ref_id);
		$criteria->compare('class',$this->class,true);
		$criteria->compare('workshop_si_name',$this->workshop_si_name,true);
		$criteria->compare('workshop_date',$this->workshop_date,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by);
		$criteria->compare('is_active',$this->is_active);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}