<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseWorkshopSiGroup is autogenerate by UniModel generator
 *
 * This is the model class for table "workshop_si_group".
 *
 * The followings are the available columns in table 'workshop_si_group':
 * @property string $workshop_si_group_id
 * @property string $workshop_si_ref_id
 * @property integer $advisor_ref_id
 * @property string $group_name
 * @property string $start_time
 * @property string $end_time
 * @property string $added_on
 * @property string $modified_on
 * @property integer $modified_by
 * @property string $comments
 *
 * The followings are the available model relations:
 * @property WorkshopSi $workshopSiRef
 * @property TblAdmin $advisorRef
 * @property TblAdmin $modifiedBy
 * @property WorkshopSiGroupFeedback[] $workshopSiGroupFeedbacks
 * @property WorkshopSiGroupStudent[] $workshopSiGroupStudents
 */
class BaseWorkshopSiGroup extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return WorkshopSiGroup the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'workshop_si_group';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('workshop_si_ref_id, advisor_ref_id, group_name, start_time, end_time, added_on', 'required'),
			array('advisor_ref_id, modified_by', 'numerical', 'integerOnly'=>true),
			array('workshop_si_ref_id', 'length', 'max'=>10),
			array('group_name', 'length', 'max'=>100),
			array('modified_on, comments', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('workshop_si_group_id, workshop_si_ref_id, advisor_ref_id, group_name, start_time, end_time, added_on, modified_on, modified_by, comments', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'workshopSiRef' => array(self::BELONGS_TO, 'WorkshopSi', 'workshop_si_ref_id'),
			'advisorRef' => array(self::BELONGS_TO, 'TblAdmin', 'advisor_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'TblAdmin', 'modified_by'),
			'workshopSiGroupFeedbacks' => array(self::HAS_MANY, 'WorkshopSiGroupFeedback', 'workshop_si_group_ref_id'),
			'workshopSiGroupStudents' => array(self::HAS_MANY, 'WorkshopSiGroupStudent', 'workshop_si_group_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'workshop_si_group_id' => 'Workshop Si Group',
			'workshop_si_ref_id' => 'Workshop Si Ref',
			'advisor_ref_id' => 'Advisor Ref',
			'group_name' => 'Group Name',
			'start_time' => 'Start Time',
			'end_time' => 'End Time',
			'added_on' => 'Added On',
			'modified_on' => 'Modified On',
			'modified_by' => 'Modified By',
			'comments' => 'Comments',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('workshop_si_group_id',$this->workshop_si_group_id,true);
		$criteria->compare('workshop_si_ref_id',$this->workshop_si_ref_id,true);
		$criteria->compare('advisor_ref_id',$this->advisor_ref_id);
		$criteria->compare('group_name',$this->group_name,true);
		$criteria->compare('start_time',$this->start_time,true);
		$criteria->compare('end_time',$this->end_time,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_on',$this->modified_on,true);
		$criteria->compare('modified_by',$this->modified_by);
		$criteria->compare('comments',$this->comments,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}