<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiSchoolVisitBoughtStudent is autogenerate by UniModel generator
 *
 * This is the model class for table "di_school_visit_bought_student".
 *
 * The followings are the available columns in table 'di_school_visit_bought_student':
 * @property string $di_school_visit_bought_student_id
 * @property integer $di_school_visit_product_ref_id
 * @property integer $school_ref_id
 * @property string $bought_type
 * @property string $di_student_selection_ref_id
 *
 * The followings are the available model relations:
 * @property DiSchoolVisitProduct $diSchoolVisitProductRef
 * @property TblSiDi $schoolRef
 * @property DiStudentSelection $diStudentSelectionRef
 */
class BaseDiSchoolVisitBoughtStudent extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiSchoolVisitBoughtStudent the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_school_visit_bought_student';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_school_visit_product_ref_id, school_ref_id, bought_type, di_student_selection_ref_id', 'required'),
			array('di_school_visit_product_ref_id, school_ref_id', 'numerical', 'integerOnly'=>true),
			array('bought_type', 'length', 'max'=>8),
			array('di_student_selection_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_school_visit_bought_student_id, di_school_visit_product_ref_id, school_ref_id, bought_type, di_student_selection_ref_id', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diSchoolVisitProductRef' => array(self::BELONGS_TO, 'DiSchoolVisitProduct', 'di_school_visit_product_ref_id'),
			'schoolRef' => array(self::BELONGS_TO, 'TblSiDi', 'school_ref_id'),
			'diStudentSelectionRef' => array(self::BELONGS_TO, 'DiStudentSelection', 'di_student_selection_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_school_visit_bought_student_id' => 'Di School Visit Bought Student',
			'di_school_visit_product_ref_id' => 'Di School Visit Product Ref',
			'school_ref_id' => 'School Ref',
			'bought_type' => 'Bought Type',
			'di_student_selection_ref_id' => 'Di Student Selection Ref',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_school_visit_bought_student_id',$this->di_school_visit_bought_student_id,true);
		$criteria->compare('di_school_visit_product_ref_id',$this->di_school_visit_product_ref_id);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('bought_type',$this->bought_type,true);
		$criteria->compare('di_student_selection_ref_id',$this->di_student_selection_ref_id,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}