<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiSchoolVisitProduct is autogenerate by UniModel generator
 *
 * This is the model class for table "di_school_visit_product".
 *
 * The followings are the available columns in table 'di_school_visit_product':
 * @property integer $di_school_visit_id
 * @property string $product_name
 * @property integer $di_ref_id
 * @property string $amount_paid
 * @property string $free_profile_count
 * @property string $discounted_profile_price
 * @property string $duration_start_date
 * @property string $duration_end_date
 * @property string $is_active
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property DiCashDebit[] $diCashDebits
 * @property DiSchoolVisitBoughtStudent[] $diSchoolVisitBoughtStudents
 * @property Di $diRef
 * @property UniVisitSchedule[] $uniVisitSchedules
 */
class BaseDiSchoolVisitProduct extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiSchoolVisitProduct the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_school_visit_product';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('product_name, di_ref_id, amount_paid, free_profile_count, discounted_profile_price, duration_start_date, duration_end_date, is_active', 'required'),
			array('di_ref_id', 'numerical', 'integerOnly'=>true),
			array('product_name', 'length', 'max'=>255),
			array('amount_paid, free_profile_count, discounted_profile_price, added_by, modified_by', 'length', 'max'=>10),
			array('is_active', 'length', 'max'=>1),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('di_school_visit_id, product_name, di_ref_id, amount_paid, free_profile_count, discounted_profile_price, duration_start_date, duration_end_date, is_active, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'diCashDebits' => array(self::HAS_MANY, 'DiCashDebit', 'school_visit_product_ref_id'),
			'diSchoolVisitBoughtStudents' => array(self::HAS_MANY, 'DiSchoolVisitBoughtStudent', 'di_school_visit_product_ref_id'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'uniVisitSchedules' => array(self::HAS_MANY, 'UniVisitSchedule', 'school_visit_product_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'di_school_visit_id' => 'Di School Visit',
			'product_name' => 'Product Name',
			'di_ref_id' => 'Di Ref',
			'amount_paid' => 'Amount Paid',
			'free_profile_count' => 'Free Profile Count',
			'discounted_profile_price' => 'Discounted Profile Price',
			'duration_start_date' => 'Duration Start Date',
			'duration_end_date' => 'Duration End Date',
			'is_active' => 'Is Active',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('di_school_visit_id',$this->di_school_visit_id);
		$criteria->compare('product_name',$this->product_name,true);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('amount_paid',$this->amount_paid,true);
		$criteria->compare('free_profile_count',$this->free_profile_count,true);
		$criteria->compare('discounted_profile_price',$this->discounted_profile_price,true);
		$criteria->compare('duration_start_date',$this->duration_start_date,true);
		$criteria->compare('duration_end_date',$this->duration_end_date,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}