<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniVisitPostStudentsInvited is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_visit_post_students_invited".
 *
 * The followings are the available columns in table 'uni_visit_post_students_invited':
 * @property string $post_invite_id
 * @property string $uni_visit_post_email_ref_id
 * @property string $student_ref_id
 * @property string $student_email
 * @property string $response
 * @property string $sent_on
 * @property string $responded_on
 *
 * The followings are the available model relations:
 * @property UniVisitPostSchoolEmail $uniVisitPostEmailRef
 * @property TblUserMaster $studentRef
 */
class BaseUniVisitPostStudentsInvited extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniVisitPostStudentsInvited the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_visit_post_students_invited';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_visit_post_email_ref_id', 'required'),
			array('uni_visit_post_email_ref_id, student_ref_id', 'length', 'max'=>10),
			array('student_email', 'length', 'max'=>255),
			array('response', 'length', 'max'=>14),
			array('sent_on, responded_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('post_invite_id, uni_visit_post_email_ref_id, student_ref_id, student_email, response, sent_on, responded_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniVisitPostEmailRef' => array(self::BELONGS_TO, 'UniVisitPostSchoolEmail', 'uni_visit_post_email_ref_id'),
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'post_invite_id' => 'Post Invite',
			'uni_visit_post_email_ref_id' => 'Uni Visit Post Email Ref',
			'student_ref_id' => 'Student Ref',
			'student_email' => 'Student Email',
			'response' => 'Response',
			'sent_on' => 'Sent On',
			'responded_on' => 'Responded On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('post_invite_id',$this->post_invite_id,true);
		$criteria->compare('uni_visit_post_email_ref_id',$this->uni_visit_post_email_ref_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('student_email',$this->student_email,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('responded_on',$this->responded_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}