<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniVisitPreStudentsInvited is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_visit_pre_students_invited".
 *
 * The followings are the available columns in table 'uni_visit_pre_students_invited':
 * @property string $invite_id
 * @property string $uni_visit_schedule_school_ref_id
 * @property string $student_ref_id
 * @property string $student_email
 * @property string $response
 * @property string $sent_on
 * @property string $responded_on
 *
 * The followings are the available model relations:
 * @property UniVisitScheduleSchool $uniVisitScheduleSchoolRef
 * @property TblUserMaster $studentRef
 */
class BaseUniVisitPreStudentsInvited extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniVisitPreStudentsInvited the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_visit_pre_students_invited';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_visit_schedule_school_ref_id, sent_on', 'required'),
			array('uni_visit_schedule_school_ref_id, student_ref_id', 'length', 'max'=>10),
			array('student_email', 'length', 'max'=>255),
			array('response', 'length', 'max'=>13),
			array('responded_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('invite_id, uni_visit_schedule_school_ref_id, student_ref_id, student_email, response, sent_on, responded_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniVisitScheduleSchoolRef' => array(self::BELONGS_TO, 'UniVisitScheduleSchool', 'uni_visit_schedule_school_ref_id'),
			'studentRef' => array(self::BELONGS_TO, 'TblUserMaster', 'student_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'invite_id' => 'Invite',
			'uni_visit_schedule_school_ref_id' => 'Uni Visit Schedule School Ref',
			'student_ref_id' => 'Student Ref',
			'student_email' => 'Student Email',
			'response' => 'Response',
			'sent_on' => 'Sent On',
			'responded_on' => 'Responded On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('invite_id',$this->invite_id,true);
		$criteria->compare('uni_visit_schedule_school_ref_id',$this->uni_visit_schedule_school_ref_id,true);
		$criteria->compare('student_ref_id',$this->student_ref_id,true);
		$criteria->compare('student_email',$this->student_email,true);
		$criteria->compare('response',$this->response,true);
		$criteria->compare('sent_on',$this->sent_on,true);
		$criteria->compare('responded_on',$this->responded_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}