<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniVisitSchedule is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_visit_schedule".
 *
 * The followings are the available columns in table 'uni_visit_schedule':
 * @property string $uni_visit_schedule_id
 * @property integer $uni_ref_id
 * @property string $event_summery
 * @property string $logo_image_email
 * @property string $banner_image_email
 * @property string $schedule_owner
 * @property string $added_on
 * @property string $added_by
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property LoginMaster $modifiedBy
 * @property TblUniversityMaster $uniRef
 * @property UniVisitScheduleAttachments[] $uniVisitScheduleAttachments
 * @property UniVisitScheduleSchool[] $uniVisitScheduleSchools
 * @property UniVisitScheduleSpeaker[] $uniVisitScheduleSpeakers
 */
class BaseUniVisitSchedule extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniVisitSchedule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_visit_schedule';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_ref_id, event_summery, schedule_owner, added_on, added_by', 'required'),
			array('uni_ref_id', 'numerical', 'integerOnly'=>true),
			array('logo_image_email, banner_image_email', 'length', 'max'=>255),
			array('schedule_owner', 'length', 'max'=>6),
			array('added_by, modified_by', 'length', 'max'=>10),
			array('modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('uni_visit_schedule_id, uni_ref_id, event_summery, logo_image_email, banner_image_email, schedule_owner, added_on, added_by, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
			'uniRef' => array(self::BELONGS_TO, 'TblUniversityMaster', 'uni_ref_id'),
			'uniVisitScheduleAttachments' => array(self::HAS_MANY, 'UniVisitScheduleAttachments', 'uni_visit_schedule_ref_id'),
			'uniVisitScheduleSchools' => array(self::HAS_MANY, 'UniVisitScheduleSchool', 'uni_visit_schedule_ref_id'),
			'uniVisitScheduleSpeakers' => array(self::HAS_MANY, 'UniVisitScheduleSpeaker', 'uni_visit_schedule_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'uni_visit_schedule_id' => 'Uni Visit Schedule',
			'uni_ref_id' => 'Uni Ref',
			'event_summery' => 'Event Summery',
			'logo_image_email' => 'Logo Image Email',
			'banner_image_email' => 'Banner Image Email',
			'schedule_owner' => 'Schedule Owner',
			'added_on' => 'Added On',
			'added_by' => 'Added By',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('uni_visit_schedule_id',$this->uni_visit_schedule_id,true);
		$criteria->compare('uni_ref_id',$this->uni_ref_id);
		$criteria->compare('event_summery',$this->event_summery,true);
		$criteria->compare('logo_image_email',$this->logo_image_email,true);
		$criteria->compare('banner_image_email',$this->banner_image_email,true);
		$criteria->compare('schedule_owner',$this->schedule_owner,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}