<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniVisitScheduleSchool is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_visit_schedule_school".
 *
 * The followings are the available columns in table 'uni_visit_schedule_school':
 * @property string $id
 * @property string $uni_visit_schedule_ref_id
 * @property integer $school_ref_id
 * @property string $event_date
 * @property string $event_start_time
 * @property string $event_end_time
 *
 * The followings are the available model relations:
 * @property UniVisitPostSchoolEmail[] $uniVisitPostSchoolEmails
 * @property UniVisitPreStudentsInvited[] $uniVisitPreStudentsInviteds
 * @property TblSiDi $schoolRef
 * @property UniVisitSchedule $uniVisitScheduleRef
 */
class BaseUniVisitScheduleSchool extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniVisitScheduleSchool the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_visit_schedule_school';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_visit_schedule_ref_id, school_ref_id, event_date, event_start_time, event_end_time', 'required'),
			array('school_ref_id', 'numerical', 'integerOnly'=>true),
			array('uni_visit_schedule_ref_id', 'length', 'max'=>10),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('id, uni_visit_schedule_ref_id, school_ref_id, event_date, event_start_time, event_end_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniVisitPostSchoolEmails' => array(self::HAS_MANY, 'UniVisitPostSchoolEmail', 'uni_visit_schedule_school_ref_id'),
			'uniVisitPreStudentsInviteds' => array(self::HAS_MANY, 'UniVisitPreStudentsInvited', 'uni_visit_schedule_school_ref_id'),
			'schoolRef' => array(self::BELONGS_TO, 'TblSiDi', 'school_ref_id'),
			'uniVisitScheduleRef' => array(self::BELONGS_TO, 'UniVisitSchedule', 'uni_visit_schedule_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'uni_visit_schedule_ref_id' => 'Uni Visit Schedule Ref',
			'school_ref_id' => 'School Ref',
			'event_date' => 'Event Date',
			'event_start_time' => 'Event Start Time',
			'event_end_time' => 'Event End Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id,true);
		$criteria->compare('uni_visit_schedule_ref_id',$this->uni_visit_schedule_ref_id,true);
		$criteria->compare('school_ref_id',$this->school_ref_id);
		$criteria->compare('event_date',$this->event_date,true);
		$criteria->compare('event_start_time',$this->event_start_time,true);
		$criteria->compare('event_end_time',$this->event_end_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}