<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseUniVisitScheduleSpeaker is autogenerate by UniModel generator
 *
 * This is the model class for table "uni_visit_schedule_speaker".
 *
 * The followings are the available columns in table 'uni_visit_schedule_speaker':
 * @property string $speaker_id
 * @property string $uni_visit_schedule_ref_id
 * @property string $speaker_name
 * @property string $speaker_designation
 *
 * The followings are the available model relations:
 * @property UniVisitSchedule $uniVisitScheduleRef
 */
class BaseUniVisitScheduleSpeaker extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return UniVisitScheduleSpeaker the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'uni_visit_schedule_speaker';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('uni_visit_schedule_ref_id, speaker_name, speaker_designation', 'required'),
			array('uni_visit_schedule_ref_id', 'length', 'max'=>10),
			array('speaker_name, speaker_designation', 'length', 'max'=>150),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('speaker_id, uni_visit_schedule_ref_id, speaker_name, speaker_designation', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'uniVisitScheduleRef' => array(self::BELONGS_TO, 'UniVisitSchedule', 'uni_visit_schedule_ref_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'speaker_id' => 'Speaker',
			'uni_visit_schedule_ref_id' => 'Uni Visit Schedule Ref',
			'speaker_name' => 'Speaker Name',
			'speaker_designation' => 'Speaker Designation',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('speaker_id',$this->speaker_id,true);
		$criteria->compare('uni_visit_schedule_ref_id',$this->uni_visit_schedule_ref_id,true);
		$criteria->compare('speaker_name',$this->speaker_name,true);
		$criteria->compare('speaker_designation',$this->speaker_designation,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}