<?php 
	Yii::import('application.modules.hotlead.models.*');
	Yii::import('application.modules.alertmatch.models.*');
	Yii::import('application.modules.shortlist.models.DiUserCriteriaShortlist');

class DiHelperPreferenceUpdate extends DiHelperBase{

/**
  * Get array list of university name and id with limit of 15 rows
  */
  
	public static function checkStudentLatestPreference($sID)
	{
		/*
			1. FIND sID related students from student_criteria_match Table and Join criteria match table based on criteria_match_id
			2. loop through found record
			3. now we have di_ref_id from criteria_match table
			4. findByPk($di_ref_id ) uni_var_id		
			5. Get students pref. department and countries
			6. get university country and departments
			7. compare both
			8. if not found then delete di_user_criteria_match
		*/	
		
		#1. SELECT DUC.di_user_criteria_id, DUCM.user_ref_id FROM di_user_criteria AS DUC,di_user_criteria_match AS DUCM WHERE (DUCM.user_ref_id=1382 AND DUCM.di_user_criteria_ref_id = DUC.di_user_criteria_id);
		
			$DiUserModel	=	new DiUser;
		
			$sql ="SELECT DUC.di_user_ref_id, DUCM.user_ref_id , DUCM.di_user_criteria_match_id, DUCM.status 
			FROM di_user_criteria AS DUC,di_user_criteria_match AS DUCM 
			WHERE (DUCM.user_ref_id='".$sID."' AND DUCM.di_user_criteria_ref_id = DUC.di_user_criteria_id)";
			$connection=Yii::app()->db;
			$command=$connection->createCommand($sql);
			$criteriaData=$command->queryAll(); // execute the non-query SQL  
			
			
			
		$stdPrefCountries = $stdPrefDepts = array();
        $countryPrefs = StudentPreferredCountry::model()->getStudentPreferredCountryDetails($sID);
        $deptPrefs    = StudentPreferredDepartment::model()->getStudentPreferredDepartmentDetails($sID);
		
		if(!$countryPrefs || !$deptPrefs) return;

		foreach($countryPrefs as $pref){
			if(!in_array($pref->country_ref_id, $stdPrefCountries))
				$stdPrefCountries[] = $pref->country_ref_id;
		}

		foreach($deptPrefs as $pref){
			if(!in_array($pref->main_dept_ref_id, $stdPrefDepts))
				$stdPrefDepts[] = $pref->main_dept_ref_id;
		}

			if(count($criteriaData)>0)
			{

				foreach($criteriaData as $criteriaData)
				{
					
						$diUserDetails = $DiUserModel->model()->findByPk($criteriaData['di_user_ref_id']);
						$uniID = $diUserDetails->diRef->uni_ref_id;
						$uniDepartments = self::getDepartmentsByUniID($uniID);
						$uni_country_id = $diUserDetails->diRef->uniRef->country_ref_id;
						$StudentFlagValidationEngine = new StudentFlagValidationEngine();
					if( (in_array($uni_country_id, $stdPrefCountries) && count(array_intersect($stdPrefDepts, $uniDepartments))) && ($StudentFlagValidationEngine->isStudentEligible($sID)) ) { 
						//die("do nothing");
					}else
					{
						if($criteriaData['status']==NULL)
						{
							$deleteUnmatchedRecord = "DELETE from di_user_criteria_match where user_ref_id = '".$sID."'";
							$connection=Yii::app()->db;
							$command=$connection->createCommand($deleteUnmatchedRecord);
							$command->execute();
							//echo "Deleted from di_user_criteria_match <br />";
							
						}else if($criteriaData['status']=='EOI')
						{
							$shortlistData = DiUserCriteriaShortlist::model()->findAllByAttributes(array('user_ref_id'=>$sID));
							foreach($shortlistData as $shortlistData){
							
								//echo $shortlistData->status;
								//echo "<br />";
							
								if($shortlistData->status=='Buy'){
									$shortlistData->status='Refund';
									$shortlistData->save(); // updated this record to refund	
								} else if(($shortlistData->status!='Refund') || ($shortlistData->status==NULL)){
									$eoi_id = $shortlistData->di_user_eoi_ref_id;
									$main_department_id = $shortlistData->main_department_ref_id;
									
									self::deleteEoiLog($sID,$main_department_id,$eoi_id);
									self::deleteFromCriteriaShortlist($sID,$main_department_id,$eoi_id);
									self::deleteFromScholarshipLog($sID,$main_department_id,$eoi_id);
									self::deleteFromScholarship($sID,$main_department_id,$eoi_id);
									self::deleteFromUserEoi($sID,$main_department_id,$eoi_id);
								}
								
							}
							
						} // else if of "IF the stuas is EOI", ends here
					} // else part of comparision if
				} // foreach for $criteriaData ends here
			} // if count($criteriaData)>0) ends here
	} // function ends

}
?>
