<?php
 
class DiEmailCampaignSettingsController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/admin';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			'rights', // perform access control for CRUD operations
		);
	}

	public function actionAdmin(){

        Yii::app()->clientScript->registerCssFile(Yii::app()->baseUrl . "/css/colorbox.css");
        Yii::app()->clientScript->registerScriptFile(Yii::app()->baseUrl . "/js/jquery.colorbox.js");

        $diID = Yii::app()->request->getParam('di_id', false);
        $model = DiEmailCampaignSettings::model()->find("di_ref_id ='".$diID."'");
        if(!$model){
            $model = new DiEmailCampaignSettings('insert');
            $model->di_ref_id = $diID;
            $model->footer_content = $this->getSampleFooterContent();
            $model->template_color_code = "#A3A3A3";
            $model->added_by  = Yii::app()->user->id;
            $model->added_on  = date('Y-m-d H:i:s');
        }else{
            $model->modified_by  = Yii::app()->user->id;
            $model->modified_on  = date('Y-m-d H:i:s');
        }

        if(Yii::app()->request->isAjaxRequest){
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }

        if(isset($_POST['DiEmailCampaignSettings'])){
            $rnd = rand(0,9999);
            $model->attributes = $_POST['DiEmailCampaignSettings'];
            $uploadPath = Yii::app()->basePath.'/../uploads/di_email_campaign_attachments/';
            if(($logoImage = CUploadedFile::getInstance($model,'logo_image')) != null){
                $model->logo_image = str_replace(' ', '', $rnd . '-'. $logoImage);
                $logoImage->saveAs($uploadPath . $model->logo_image);
            }
            if(($bannerImage = CUploadedFile::getInstance($model,'banner_image')) != null){
                $model->banner_image = str_replace(' ', '', $rnd . '-'. $bannerImage);
                $bannerImage->saveAs($uploadPath . $model->banner_image);

            }
            if(($templateImage = CUploadedFile::getInstance($model,'template_image')) !=null){
                $model->template_image = str_replace(' ', '', $rnd . '-'. $templateImage);
                $templateImage->saveAs($uploadPath . $model->template_image);
            }

            if($model->validate() && $model->save()){

            }
        }

        $this->render('settings',array(
            'model'=>$model,
            'di_id'=>$diID,
        ));
    }

    public function actionPreviewTemplate(){

        $Message = "This is simply a dummy text to show how the content is going to display. Lorem Ipsum has been the industry's standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960s with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.";

        $templateData = $_POST['DiEmailCampaignSettings'];
        $this->renderPartial('di.views.emailcampaign.preview_campaign', array(
            'diID'              => Yii::app()->request->getParam('di_id', false),
            'campaignHeader'    => 'This is simply a dummy title',
            'campaignContent'   => $Message,
            'targetLink'        => '#',
            'targetLable'       => 'Dummy Link',

            'templateColor'     => $templateData['template_color_code'],
            'templateFooter'     => $templateData['footer_content'],
        ));
    }

    private function getSampleFooterContent(){

        return '<table style="border: none; width: 100%">
                <tr>
                    <td style="width: 33%">
                        <table style="border: none; width: 100%">
                            <tr><td>Address Line 1</td></tr>
                            <tr><td>Address Line 2</td></tr>
                            <tr><td>&nbsp;</td></tr>
                        </table>
                    </td>
                    <td style="width: 33%">
                        <table style="border: none; width: 100%">
                            <tr><td>Email : fakeemail@gmail.com</td></tr>
                            <tr><td>Phone : +91-20-123456789</td></tr>
                            <tr><td>&nbsp;</td></tr>
                        </table>
                    </td>
                    <td style="width: 33%">
                        <table style="border: none; width: 100%">
                            <tr><td>Web: http://fakewebsite.com </td></tr>
                            <tr><td>&nbsp;</td></tr>
                            <tr><td>&nbsp;</td></tr>
                        </table>
                    </td>
                </tr>
            </table>';
    }
}
