<?php
 
class DiProductCreditController extends Controller
{
	/**
	 * @var string the default layout for the views. Defaults to '//layouts/column2', meaning
	 * using two-column layout. See 'protected/views/layouts/column2.php'.
	 */
	public $layout='//layouts/admin';

	/**
	 * @return array action filters
	 */
	public function filters()
	{
		return array(
			//'rights', // perform access control for CRUD operations
		);
	}

	/**
	 * Specifies the access control rules.
	 * This method is used by the 'accessControl' filter.
	 * @return array access control rules
	 */
	public function accessRules()
	{
		return array(
			array('allow',  // allow all users to perform 'index' and 'view' actions
				'actions'=>array('index','view'),
				'users'=>array('*'),
			),
			array('allow', // allow authenticated user to perform 'create' and 'update' actions
				'actions'=>array('create','update','admin','delete','extraCredit'),
				'users'=>array('@'),
			),
			array('allow', // allow admin user to perform 'admin' and 'delete' actions
				'actions'=>array('admin','delete'),
				'users'=>array('admin'),
			),
			array('deny',  // deny all users
				'users'=>array('*'),
			),
		);
	}

	/**
	 * Displays a particular model.
	 * @param integer $id the ID of the model to be displayed
	 */
	public function actionView($id)
	{
		$this->render('view',array(
			'model'=>$this->loadModel($id),
		));
	}

	/**
	 * Creates a new model.
	 * If creation is successful, the browser will be redirected to the 'view' page.
	 */
	public function actionCreate()
	{
        $id             =   Yii::app()->getRequest()->getQuery('di_id');
        $ProductData    =   DiHelper::GetProductType($product_id="",$UserType_id='3');
        $ListData       =   CHtml::listData($ProductData,'product_id', 'product_shortcode');
        $model          =   new DiProductCredit;

        if(isset($_REQUEST['FST']) && $_REQUEST['FST']=='YS') {
            $Button         =   CHtml::link('Done',array('/diadmin/di/sendmail','di_id'=>$id,'SUCCESS'=>'REGISTRATION'),array('class'=>'button'));
        }else{
            $Button         =   CHtml::link('<< Back',array('/diadmin/diProductCredit/admin/','di_id'=>$id),array('class'=>'button'));
        }


		// Uncomment the following line if AJAX validation is needed
		$this->performAjaxValidation($model);

        if(isset($_POST['DiProductCredit']))
		{

                $model->attributes          =   $_POST['DiProductCredit'];
                $model->di_ref_id           =   $id;
                $model->added_on            =   new CDbExpression('NOW()');
                $model->added_by            =   Yii::app()->user->id;

            if($model->validate())
                if($model->save()){
                    Yii::app()->user->setFlash('updated',"Success! Free credits added to DI account");
                    if(isset($_REQUEST['FST']) && $_REQUEST['FST']=='YS') {
                        $this->redirect(array('create','di_id'=>$id,'FST'=>'YS'));
                    }else{
                        $this->redirect(array('create','di_id'=>$id));
                    }

              }
		}

		$this->render('create',array(
			'model'=>$model,
			'ProductData'=>$ListData,
			'id'=>$id,
			'button'=>$Button,
		));
	}

    public function actionExtraCredit()
    {
        $id             =   Yii::app()->getRequest()->getQuery('di_id');
        $diData         =   DiHelper::GetDiDetails($id);
        $ProductData    =   DiHelper::GetProductType($product_id="",$UserType_id='3');
        $ListData       =   CHtml::listData($ProductData,'product_id', 'product_shortcode');

        if(isset($_REQUEST['FST']) && $_REQUEST['FST']=='YS') {
            $Button         =   CHtml::link('Done',array('/diadmin/di/sendmail','di_id'=>$id,'SUCCESS'=>'REGISTRATION'),array('class'=>'button'));
        }else{
            $Button         =   CHtml::link('<< Back',array('/diadmin/diProductCredit/admin/','di_id'=>$id),array('class'=>'button'));
        }


        // Uncomment the following line if AJAX validation is needed
        //$this->performAjaxValidation($model);

        if(isset($_POST['count']))
        {
            $count  =   0;
            $Product          =        $_POST['count'];
            foreach($_POST['count'] as $key => $data){
                if($data!=""){

                    $model          =   new DiProductCredit;
                    $model->product_ref_id      =   $key;
                    $model->credit_count        =   $data;
                    $model->di_ref_id           =   $id;
                    $model->added_on            =   new CDbExpression('NOW()');
                    $model->added_by            =   Yii::app()->user->id;
                    $model->save();
                    $count++;
                }
            }

            if($count!=0){
                $diName     =   $diData->diUsers[0]->first_name." ".$diData->diUsers[0]->last_name;
                $msg        =   $this->renderPartial('/mailformat/ExtraCredits', array('name'=>$diName,'product'=>$Product),true,false);

                Yii::app()->user->setFlash('updated',"Success! Extra credits added to DI account");
                $params = array();
                $params['EmailMessage']['subject']      =   'Congratulations! Free credits added to your account';
                $params['EmailMessage']['body']         =   $msg;
                $params['EmailMessage']['type']         =   'DIRegistration';
                $params['EmailMessage']['siteUrl']      =   '';
                $params['EmailMessage']['cc']           =   '';
                $params['EmailMessage']['toName']       =   $diName;
                $params['EmailMessage']['toEmail']      =   $diData->diUsers[0]->loginRef->username;
                $params['EmailMessage']['apiKey']       =   Yii::app()->params['emailCron']['curlKey'];
                $_POST = $params;
                Yii::app()->user->setState('$_POST', $this->createUrl('sms/email/addMessage'));
                //$status = Yii::app()->runController("sms/email/addMessage");

            }else{
				Yii::app()->user->setFlash('error',"No Data Inserted !");
			}
                if(isset($_REQUEST['FST']) && $_REQUEST['FST']=='YS') {
                    $this->redirect(array('extraCredit','di_id'=>$id,'FST'=>'YS'));
                }else{
                    $this->redirect(array('admin','di_id'=>$id));
                }
        }

        $this->render('extra',array(
            'ProductData'=>$ListData,
            'id'=>$id,
            'button'=>$Button,
        ));
    }
	/**
	 * Updates a particular model.
	 * If update is successful, the browser will be redirected to the 'view' page.
	 * @param integer $id the ID of the model to be updated
	 */
	public function actionUpdate($id)
	{

        if(isset($_REQUEST['FST']) && $_REQUEST['FST']=='YS') {
            $Button         =   CHtml::link('Done',array('/diadmin/di/sendmail','di_id'=>$id,'SUCCESS'=>'REGISTRATION'),array('class'=>'button'));
        }else{
            $Button         =   CHtml::button('<< Back',array('class'=>'button','onClick'=>'javascript:window.history.back()'));
        }

        $ProductData    =   DiHelper::GetProductType($product_id="",$UserType_id='3');
        $ListData       =   CHtml::listData($ProductData,'product_id', 'product_shortcode');

		$model=$this->loadModel($id);

		// Uncomment the following line if AJAX validation is needed
		$this->performAjaxValidation($model);

		if(isset($_POST['DiProductCredit']))
		{
            if(isset($_POST['DiProductCredit']))
            {
                $model->attributes              =   $_POST['DiProductCredit'];
                $model->modified_on            =   new CDbExpression('NOW()');
                $model->modified_by            =   Yii::app()->user->id;

                if($model->validate())
                    if($model->save()){
                        Yii::app()->user->setFlash('updated',"Value inserted successfully");
                        $this->redirect(array('admin','di_id'=>$model->di_ref_id));
                    }
            }

		}

        $this->render('update',array(
            'model'=>$model,
            'ProductData'=>$ListData,
            'id'=>$id,
            'button'=>$Button,
        ));
	}

	/*
	 * Deletes a particular model.
	 * If deletion is successful, the browser will be redirected to the 'admin' page.
	 * @param integer $id the ID of the model to be deleted
	 */
	public function actionDelete($id)
	{
		if(Yii::app()->request->isPostRequest)
		{
			// we only allow deletion via POST request
			$this->loadModel($id)->delete();

			// if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
			if(!isset($_GET['ajax']))
				$this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
		}
		else
			throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
	}

	/**
	 * Lists all models.
	 */
	public function actionIndex()
	{
		$dataProvider=new CActiveDataProvider('DiProductCredit');
		$this->render('index',array(
			'dataProvider'=>$dataProvider,
		));
	}

	/**
	 * Manages all models.
	 */
	public function actionAdmin()
	{
       $id  =    Yii::app()->getRequest()->getQuery('di_id');
		$model=new DiProductCredit('search');
		$model->unsetAttributes();  // clear any default values
		if(isset($_GET['DiProductCredit']))
			$model->attributes=$_GET['DiProductCredit'];

		$this->render('admin',array(
			'model'=>$model,
			'id'=>$id,
		));
	}

    public function actionAdd(){

    }
	/**
	 * Returns the data model based on the primary key given in the GET variable.
	 * If the data model is not found, an HTTP exception will be raised.
	 * @param integer the ID of the model to be loaded
	 */
	public function loadModel($id)
	{
		$model=DiProductCredit::model()->findByPk($id);
		if($model===null)
			throw new CHttpException(404,'The requested page does not exist.');
		return $model;
	}

	/**
	 * Performs the AJAX validation.
	 * @param CModel the model to be validated
	 */
	protected function performAjaxValidation($model)
	{
		if(isset($_POST['ajax']) && $_POST['ajax']==='di-product-credit-form')
		{
			echo CActiveForm::validate($model);
			Yii::app()->end();
		}
	}
}
