<?php

class ModeratorsController extends Controller
{
    public $layout='//layouts/admin';

    /**
     * @return array action filters
     */
    public function filters()
    {
        return array(
            'rights', // perform access control for CRUD operations
        );
    }

    /**
     * Displays a particular model.
     * @param integer $id the ID of the model to be displayed
     */
    public function actionView($id)
    {
        $this->render('view',array(
            'model'=>$this->loadModel($id),
        ));
    }

    public function actionIndex()
    {
        // if Univarity admin then di_id must be in url
        $di_id = Yii::app()->getRequest()->getQuery('di_id');

        if($di_id==""){
            if(isset(Yii::app()->user->di_id) && is_numeric(Yii::app()->user->di_id)){
                $di_id = Yii::app()->user->di_id;
            } else{
                $di_id = 0;
            }
        }
        #==================================

        $model=new DiUser('search');
        $model->unsetAttributes();  // clear any default values
        if(isset($_GET['DiUser']))
            $model->attributes=$_GET['DiUser'];

        $this->render('admin',array(
            'model'=>$model,
            'di_id'=>$di_id,
        ));

    }

    /**
     * Creates a new model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     */
    # Create Di Moderator Account

    public function actionCreate()
    {
        #= Di Admin OR Univaritey Admin =====================
        // if Univarity admin then di_id must be in url
        $di_id = Yii::app()->getRequest()->getQuery('di_id');

        if($di_id==""){ //// Then must be di moderator //
            if(isset(Yii::app()->user->di_id) && is_numeric(Yii::app()->user->di_id)){
                $di_id = Yii::app()->user->di_id; //get Di id From login session
            } else{
                $di_id = 0;
            }
        }
        #==================================
        $Di             =   DiHelper::GetDiDetails($di_id);


        $model 		    = 	new DiUser;
        $LoginMaster    =   new LoginMaster('register');
        $DiUserDepart	= 	new DiUserDepartment;

		$model->is_active = 1; // set default active
		
        //Set default user type Admin
        $model->user_type = "Moderator";

        // Uncomment the following line if AJAX validation is needed
        $this->performAjaxValidation(array($model,$LoginMaster,$DiUserDepart));

        if(isset($_POST['DiUser']))
        {

            $LoginMaster->attributes    =   $_POST['LoginMaster'];
            $DiUserDepart->attributes	=	$_POST['DiUserDepartment'];
            $departmentArray			=	$_POST['DiUserDepartment']['main_department_ref_id'];
            $model->attributes			=	$_POST['DiUser'];

            // Auto Fill login_master fields
            $LoginMaster->is_active         =   $model->is_active; // Set login_master.is_active same as di_user.is_active
            $LoginMaster->user_type_ref_id	=	3; #DI type lookup_user_type
            $LoginMaster->added_on			=	new CDbExpression('NOW()');
            $pass_word					    =	DiHelper::genPassword($length = 10);
            $LoginMaster->pass_word			=	$pass_word;

            // Auto Fill di_user fields
            $model->di_ref_id           =   $di_id; // di_id from di table
            $model->added_by		    =	Yii::app()->user->id;
            $model->modified_by		    =	Yii::app()->user->id;
            $model->added_on			=	new CDbExpression('NOW()');

            // validate Models data
            $modelValid 				=	$model->validate(); // di_user validate
            $LoginMasterValid 			=	$LoginMaster->validate();//login_master validate
            $DiUserDepartValid 		    =	$DiUserDepart->validate();//di_user_department validate

            if($modelValid && $LoginMasterValid && $DiUserDepartValid)
            {
                if($LoginMaster->save()) { // Create Login id first save in login_master
                    $model->login_ref_id   = $LoginMaster->login_id; // Assign login_id in di_user table

                    if($model->save()){ // Save user in di_user table

						Yii::import('application.modules.counselorsuggest.components.*');
						$PmsToDiUserProcess = new PmsToDiUserProcess;
						$PmsToDiUserProcess->diUserId = $model->di_user_id;
						$PmsToDiUserProcess->init();
						$PmsToDiUserProcess->assignPmsToDiUser();
					
                        DiHelper::RbacInsert($LoginMaster->login_id,'DiModerator');

                        // Save fresh copy for departments
                        // pass department array and di_user data
                        $this->saveDepartments($departmentArray,$model);

                        // Set User friendly version of password to send in mail
                        $model->loginRef->pass_word = $pass_word;

                        //Create  di_user_id
                        $di_user_id = $model->di_user_id;
                        $this->sendMailToModerator($model,$di_user_id);

                        Yii::app()->user->setFlash('updated','Congratulations! Moderator account has been created successfully');

                        // Redirect bases on Univariety Admin or Di Admin
                        if(Yii::app()->controller->module->id=="diadmin"){
                            $this->redirect(array('/diadmin/moderators/index','di_id'=>$di_id));
                        } else{
                            $this->redirect(array('/diaccount/moderators'));
                        }

                    }
                }
            }// if isValid

        }// If Porm posted


        $this->render('create',array(
            'model'=>$model,
            'LoginMaster'=>$LoginMaster,
            'DiUserDepart'=>$DiUserDepart,
            'Di'=> $Di,
        ));
    }

    /**
     * Updates a particular model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id the ID of the model to be updated
     */
    public function actionUpdate($id)
    {
        // $model          = DiUser::model()->findByPk($id);
        $model          = $this->loadModel($id);

        $LoginMaster    = $model->loginRef;

        $DiUserDepart				= 	new DiUserDepartment;
        $selectedDepartArr 			=	DiHelper::getDepartmentList($model->di_user_id);
        $DiUserDepart->main_department_ref_id =  array_keys($selectedDepartArr);


        // Uncomment the following line if AJAX validation is needed
        $this->performAjaxValidation($model);



        if(isset($_POST['DiUser']))
        {
            $model->attributes			=	$_POST['DiUser'];
            $DiUserDepart->attributes	=	$_POST['DiUserDepartment'];
            $departmentArray			=	$_POST['DiUserDepartment']['main_department_ref_id'];

            // Auto Fill di_user fields
            $model->modified_by		=	Yii::app()->user->id;
            $model->modified_on		=	new CDbExpression('NOW()');

            // validate Models data
            $modelValid 				=	$model->validate();
            $DiUserDepartValid 		    =	$DiUserDepart->validate();

            if($modelValid && $DiUserDepartValid)
            {
                if($model->save()){
				
					$LoginMaster->is_active         =   $model->is_active; // Set login_master.is_active same as di_user.is_active
					$LoginMaster->save();

                    // Save fresh copy for departments
                    // pass department array and di_user data
                    $this->saveDepartments($departmentArray,$model);
                    Yii::app()->user->setFlash('updated','Congratulations! Moderator account has been updated successfully');

                    // Redirect bases on Univariety Admin or Di Admin
                    if(Yii::app()->controller->module->id=="diadmin"){
                        $this->redirect(array('/diadmin/moderators/index','di_id'=>$model->diRef->di_id));
                    } else{
                        $this->redirect(array('/diaccount/moderators'));
                    }


                }
            }
        }

        $this->render('update',array(
            'model'         => $model,
            'LoginMaster'   => $LoginMaster,
            'DiUserDepart'  => $DiUserDepart,
            'Di'            => $model->diRef,
        ));
    }


    /**
     * Deletes a particular model.
     * If deletion is successful, the browser will be redirected to the 'admin' page.
     * @param integer $id the ID of the model to be deleted
     */
    public function actionDelete($id)
    {

        /*
        $model = $this->loadModel($id);
        $diUserId   = $model->di_user_id;

        DiHelper::deleteDiUserHotlead($diUserId); // Delete function
        DiHelper::deleteDiUserDepartment($diUserId)); // Delete function

        DiHelper::deleteDiUserEoi($diUserId); // Delete function
        DiHelper::deleteDiUserEoiLog($diUserId); // Delete function

        $login_master_id = DiHelper::deleteDiUser($diUserId); // Delete function
        if($login_master_id){
            DiHelper::deleteLoginMaster($login_master_id); // Delete function
        }


        if(Yii::app()->request->isPostRequest)
        {
            // we only allow deletion via POST request
            $model = $this->loadModel($id);

            if($model->user_type != 'Admin'){
                $diUserId   = $model->di_user_id;

                if(DiHelper::deleteDiUserHotlead($diUserId)){

                    if(DiHelper::deleteDiUserDepartment($diUserId)){
                        $login_master_id = DiHelper::deleteDiUser($diUserId);
                        if($login_master_id){
                            DiHelper::deleteLoginMaster($login_master_id);
                        }
                    }//deleteDiUserDepartment

                }

            }



            // if AJAX request (triggered by deletion via admin grid view), we should not redirect the browser
            if(!isset($_GET['ajax']))
                $this->redirect(isset($_POST['returnUrl']) ? $_POST['returnUrl'] : array('admin'));
        }
        else
            throw new CHttpException(400,'Invalid request. Please do not repeat this request again.');
        */
    }

    /**
     * Manages all models.
     */
    /*
	public function actionAdmin()
	{

        die("Invalid Request");
        $model=new DiUser('search');
        $model->unsetAttributes();  // clear any default values
        if(isset($_GET['DiUser']))
            $model->attributes=$_GET['DiUser'];

        $this->render('admin',array(
            'model'=>$model,
        ));
	}
    */






    public function loadModel($id)
    {
        $model=DiUser::model()->findByPk($id);
        if($model===null)
            throw new CHttpException(404,'The requested page does not exist.');
        return $model;
    }

    /**
     * Performs the AJAX validation.
     * @param CModel the model to be validated
     */
    protected function performAjaxValidation($model)
    {
        if(isset($_POST['ajax']) && $_POST['ajax']==='di-moderators-form')
        {
            echo CActiveForm::validate($model);
            Yii::app()->end();
        }
    }


    /* Custom Controller Functions */
    /*
     * Mail Functionality for Moderator
     */

    protected function sendMailToModerator($model,$di_user_id){

        // $model - is currently new registered moderators DiUser object
        // $di_id - is di_id of parent of this new registered moderator

        // Parent di_user data of this moderator
        $DiUser = DiUser::model()->findByPk($di_user_id);

        $data =    array(
            'username'          =>   $model->loginRef->username,
            'password'          =>   $model->loginRef->pass_word,
            'FirstName'         =>   $model->first_name,
            'LastName'          =>   $model->last_name,
            'DiName'            =>   $DiUser->first_name,
            'Departments'       =>   DiHelper::displayDepartments($DiUser->di_user_id),
        );

        $msg        =   $this->renderPartial('/mailformat/di_moderator_registration', array('data'=>$data),true,false);

        $params = array();
        $params['EmailMessage']['subject']      =   'Welcome to Univariety: Your Univariety.com account details';
        $params['EmailMessage']['body']         =   $msg;
        $params['EmailMessage']['type']         =   'DIModeratorRegistration';
        $params['EmailMessage']['siteUrl']      =   '';
        $params['EmailMessage']['cc']           =   '';
        $params['EmailMessage']['toName']       =   $model->first_name.' '.$model->last_name;
        $params['EmailMessage']['toEmail']      =   $model->loginRef->username;
        $params['EmailMessage']['apiKey']       =   Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;

        Yii::app()->user->setState('$_POST', $this->createUrl('sms/email/addMessage'));
        $status = Yii::app()->runController("sms/email/addMessage");

    }
	
	
	 function actionSendmailUpdatePassword($data   =   array()){
        $msg        =   $this->renderPartial('/mailformat/di-updatePassword', array('data'=>$data),true,false);
        $params = array();
        $params['EmailMessage']['subject']      =   'Univariety: Password changed successfully!';
        $params['EmailMessage']['body']         =   $msg;
        $params['EmailMessage']['type']         =   'DIRegistration';
        $params['EmailMessage']['siteUrl']      =   '';
        $params['EmailMessage']['cc']           =   '';
        $params['EmailMessage']['toName']       =   $data['FirstName'].' '.$data['LastName'];
        $params['EmailMessage']['toEmail']      =   $data['username'];
        $params['EmailMessage']['apiKey']       =   Yii::app()->params['emailCron']['curlKey'];
        $_POST = $params;
        Yii::app()->user->setState('$_POST', $this->createUrl('sms/email/addMessage'));
        $status = Yii::app()->runController("sms/email/addMessage");
        //;
    }
	

    protected function saveDepartments($departmentArray,$DiUser) {
        /**
         * This Function will be shared in Create and update
         * First Delete all Departments and add fresh assigned
         */

        $Userdepartment	= 	new DiUserDepartment;
        $Userdepartment->deleteAll(array('condition'=>'di_user_ref_id=:x', 'params'=>array(':x'=>$DiUser->di_user_id)));
        foreach($departmentArray as $data) {
            $Userdepartment								= 	new DiUserDepartment;
            $Userdepartment->main_department_ref_id		=	$data;
            $Userdepartment->di_user_ref_id				=	$DiUser->di_user_id;
            $Userdepartment->is_active					=	$DiUser->is_active;
            $Userdepartment->added_on					=	$DiUser->added_on;
            $Userdepartment->added_by					=	$DiUser->added_by;
            $Userdepartment->modified_on				=	$DiUser->modified_on;
            $Userdepartment->modified_by				=	$DiUser->modified_by;
            $Userdepartment->save();
        }

    }
	
	/* Change password */
	public function actionChangepassword($id)
	{
		$DiUser=$this->loadModel($id);
		
		$LoginMaster		= new LoginMaster('DiModuleChangePassword');
		$LoginMaster		= $DiUser->loginRef;
		$LoginMaster->scenario = 'DiModuleChangePassword';
		
		if(isset($_POST['LoginMaster'])){
		
			$LoginMaster->pass_word = $_POST['LoginMaster']['pass_word'];
			
			if($LoginMaster->validate()){
				$LoginMaster->pass_word = md5($LoginMaster->pass_word);
				if($LoginMaster->save(false)){
				
					$data           =    array(
										'username'          =>   $LoginMaster->username,
										'password'          =>   $_POST['LoginMaster']['pass_word'],
										'FirstName'         =>   $DiUser->first_name,
										'LastName'          =>   $DiUser->last_name,
										'di_id'             =>   $DiUser->diRef->di_id,
									);
									
									
					Yii::app()->user->setFlash('updated',"Congratulations! DI password has been changed  successfully. Note: Credentials to Log In have been emailed to Di email");
					self::actionSendmailUpdatePassword($data); # to send mail
				
					$this->redirect(array('/diadmin/moderators/index','di_id'=>$DiUser->diRef->di_id));
				}
			}//if validation ok
			
		}
		
		$LoginMaster->pass_word  = "";
		$this->render('changepassword',array('LoginMaster'=>$LoginMaster));

	}	


}
?>