<?php

/**
/*
 * @author Asif Ali M
 * @package application.models 
 * 
 * BaseDiEmailCampaignSettings is autogenerate by UniModel generator
 *
 * This is the model class for table "di_email_campaign_settings".
 *
 * The followings are the available columns in table 'di_email_campaign_settings':
 * @property integer $settings_id
 * @property integer $di_ref_id
 * @property string $template_color_code
 * @property string $footer_content
 * @property string $logo_image
 * @property string $banner_image
 * @property string $template_image
 * @property string $added_by
 * @property string $added_on
 * @property string $modified_by
 * @property string $modified_on
 *
 * The followings are the available model relations:
 * @property LoginMaster $addedBy
 * @property Di $diRef
 * @property LoginMaster $modifiedBy
 */
class BaseDiEmailCampaignSettings extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DiEmailCampaignSettings the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'di_email_campaign_settings';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('di_ref_id, template_color_code, footer_content', 'required'),
			array('di_ref_id', 'numerical', 'integerOnly'=>true),
			array('template_color_code, added_by, modified_by', 'length', 'max'=>10),
			array('logo_image, banner_image, template_image', 'length', 'max'=>100),
			array('added_on, modified_on', 'safe'),
			// The following rule is used by search().
			// Please remove those attributes that should not be searched.
			array('settings_id, di_ref_id, template_color_code, footer_content, logo_image, banner_image, template_image, added_by, added_on, modified_by, modified_on', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'addedBy' => array(self::BELONGS_TO, 'LoginMaster', 'added_by'),
			'diRef' => array(self::BELONGS_TO, 'Di', 'di_ref_id'),
			'modifiedBy' => array(self::BELONGS_TO, 'LoginMaster', 'modified_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'settings_id' => 'Settings',
			'di_ref_id' => 'Di Ref',
			'template_color_code' => 'Template Color Code',
			'footer_content' => 'Footer Content',
			'logo_image' => 'Logo Image',
			'banner_image' => 'Banner Image',
			'template_image' => 'Template Image',
			'added_by' => 'Added By',
			'added_on' => 'Added On',
			'modified_by' => 'Modified By',
			'modified_on' => 'Modified On',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		// Warning: Please modify the following code to remove attributes that
		// should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('settings_id',$this->settings_id);
		$criteria->compare('di_ref_id',$this->di_ref_id);
		$criteria->compare('template_color_code',$this->template_color_code,true);
		$criteria->compare('footer_content',$this->footer_content,true);
		$criteria->compare('logo_image',$this->logo_image,true);
		$criteria->compare('banner_image',$this->banner_image,true);
		$criteria->compare('template_image',$this->template_image,true);
		$criteria->compare('added_by',$this->added_by,true);
		$criteria->compare('added_on',$this->added_on,true);
		$criteria->compare('modified_by',$this->modified_by,true);
		$criteria->compare('modified_on',$this->modified_on,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}